/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */

#ifndef	ucd_mem_map_H_
#define	ucd_mem_map_H_

#if !defined(_SCC_TYPES_H_)
#include	"scc_types.h"
#endif

struct ucd_mem_type {
	unsigned char rule:5;
	unsigned char mmap_p:1;
	unsigned char fm_y_p:1;
	unsigned char fm_c_p:1;
};
enum {
	UCD_MEM_TYPE_VIDEO,
	UCD_MEM_TYPE_GFX0,
	UCD_MEM_TYPE_DEC0_0,
	UCD_MEM_TYPE_DEC1_0,
	UCD_MEM_TYPE_ENC0_0,
	UCD_MEM_TYPE_ENC1_0,
	UCD_MEM_TYPE_DEC0_1,
	UCD_MEM_TYPE_DEC1_1,
	UCD_MEM_TYPE_ENC0_1,
	UCD_MEM_TYPE_ENC1_1,
	UCD_MEM_TYPE_JPEG,
	UCD_MEM_TYPE_N,
	UCD_MEM_TYPE_SOC,
	UCD_MEM_TYPE_DDR0,
	UCD_MEM_TYPE_DDR1,
	UCD_MEM_TYPE_EXBUS,
	UCD_MEM_TYPE_NOTUSED,
	UCD_MEM_TYPE_UCODE,
};

struct mem_map_sub {
	UINT32 offset;
	UINT32 size;
};

#define DO_NOT_USE                     0
#define MEM_MAP_SUB_N                  1

struct mem_map {
	int mmap_n;
	struct ucd_mem_type type;
	struct mem_map_sub *sub[MEM_MAP_SUB_N];
};

#define	UCDD_MEM_RLE1                                     0
#define	UCDD_MEM_RLE2                                     1
#define	UCDD_MEM_RLEIOP0                                  2
#define	UCDD_MEM_RLEIOP1                                  3
#define	UCDD_MEM_RLEDMAC                                  4
#define	UCDD_MEM_FDMAC                                    5
#define	UCDD_MEM_SYS                                      6
#define	UCDD_MEM_HCM                                      7
#define	UCDD_MEM_HSC                                      8
#define	UCDD_MEM_AIOF                                     9
#define	UCDD_MEM_IPR                                      10
#define	UCDD_MEM_VOUT                                     11
#define	UCDD_MEM_HOSTIOP                                  12
#define	UCDD_MEM_HASI                                     13
#define	UCDD_MEM_LOSD                                     14
#define	UCDD_MEM_AVCORE                                   15
#define	UCDD_MEM_SOCGLUE                                  16
#define	UCDD_MEM_DDR_DDR_CH0                              17
#define	UCDD_MEM_DDR_INST_PARAM                           18
#define	UCDD_MEM_DDR_DPPINSTST_0_H264                     19
#define	UCDD_MEM_DDR_HCMDDR_OFFSET                        20
#define	UCDD_MEM_DDR_JPEG_TABLE0                          21
#define	UCDD_MEM_DDR_JPEG_HUFFMAN_TABLE0                  22
#define	UCDD_MEM_DDR_JPEG_Q_TABLE0                        23
#define	UCDD_MEM_DDR_JPEG_TABLE1                          24
#define	UCDD_MEM_DDR_JPEG_HUFFMAN_TABLE1                  25
#define	UCDD_MEM_DDR_JPEG_Q_TABLE1                        26
#define	UCDD_MEM_DDR_UDLWORK                              27
#define	UCDD_MEM_DDR_SABB0                                28
#define	UCDD_MEM_DDR_SABB1                                29
#define	UCDD_MEM_DDR_SABB2                                30
#define	UCDD_MEM_DDR_SAE2B0                               31
#define	UCDD_MEM_DDR_ADB                                  32
#define	UCDD_MEM_DDR_ABB0                                 33
#define	UCDD_MEM_DDR_ABB1                                 34
#define	UCDD_MEM_DDR_ABB2                                 35
#define	UCDD_MEM_DDR_AOB                                  36
#define	UCDD_MEM_DDR_AOB0                                 37
#define	UCDD_MEM_DDR_AOB1                                 38
#define	UCDD_MEM_DDR_AOB2                                 39
#define	UCDD_MEM_DDR_AIB                                  40
#define	UCDD_MEM_DDR_AIB0                                 41
#define	UCDD_MEM_DDR_AIB1                                 42
#define	UCDD_MEM_DDR_REMASTER0                            43
#define	UCDD_MEM_DDR_REMASTER1                            44
#define	UCDD_MEM_DDR_HBASSPARAM0                          45
#define	UCDD_MEM_DDR_HBASSPARAM1                          46
#define	UCDD_MEM_DDR_PCMMIX0                              47
#define	UCDD_MEM_DDR_PCMMIX1                              48
#define	UCDD_MEM_DDR_PCMMIX2                              49
#define	UCDD_MEM_DDR_BRFILTERCOEF0                        50
#define	UCDD_MEM_DDR_BRFILTERCOEF1                        51
#define	UCDD_MEM_DDR_BRFILTERCOEF2                        52
#define	UCDD_MEM_DDR_AUDMIXM2A                            53
#define	UCDD_MEM_DDR_AUDMIXM2B                            54
#define	UCDD_MEM_DDR_AUDMIXM2C                            55
#define	UCDD_MEM_DDR_AUDMIXM2D                            56
#define	UCDD_MEM_DDR_AUDMIXM2E                            57
#define	UCDD_MEM_DDR_AUDMIXM2F                            58
#define	UCDD_MEM_DDR_AUDMIXM2G                            59
#define	UCDD_MEM_DDR_AUDMIXM2H                            60
#define	UCDD_MEM_DDR_AEB0                                 61
#define	UCDD_MEM_DDR_AEB1                                 62
#define	UCDD_MEM_DDR_TRANS_AEB0                           63
#define	UCDD_MEM_DDR_TRANS_AEB1                           64
#define	UCDD_MEM_DDR_SIT_AND_PMT0                         65
#define	UCDD_MEM_DDR_SIT_AND_PMT1                         66
#define	UCDD_MEM_DDR_APTS_TABLE_DEC                       67
#define	UCDD_MEM_DDR_APTS_TABLE_DEC0                      68
#define	UCDD_MEM_DDR_APTS_TABLE_DEC1                      69
#define	UCDD_MEM_DDR_APTS_TABLE_DEC2                      70
#define	UCDD_MEM_DDR_RMAACFRM0                            71
#define	UCDD_MEM_DDR_RMAACFRM1                            72
#define	UCDD_MEM_DDR_RMAACFRM2                            73
#define	UCDD_MEM_DDR_ADECINF0                             74
#define	UCDD_MEM_DDR_ADECINF1                             75
#define	UCDD_MEM_DDR_ADECINF2                             76
#define	UCDD_MEM_DDR_APTS_TABLE0                          77
#define	UCDD_MEM_DDR_APTS_TABLE1                          78
#define	UCDD_MEM_DDR_SDCARD                               79
#define	UCDD_MEM_DDR_AE1B0                                80
#define	UCDD_MEM_DDR_AE2B0                                81
#define	UCDD_MEM_DDR_CEB0                                 82
#define	UCDD_MEM_DDR_AE1PTS_TABLE0                        83
#define	UCDD_MEM_DDR_AE2PTS_TABLE0                        84
#define	UCDD_MEM_DDR_CEPTS_TABLE0                         85
#define	UCDD_MEM_DDR_FCARDADDR                            86
#define	UCDD_MEM_DDR_COEF                                 87
#define	UCDD_MEM_DDR_FCCOEF                               88
#define	UCDD_MEM_DDR_TELETEXT                             89
#define	UCDD_MEM_DDR_MNIP_Y                               90
#define	UCDD_MEM_DDR_MNIP_C                               91
#define	UCDD_MEM_DDR_MVR_Y0                               92
#define	UCDD_MEM_DDR_MVR_Y1                               93
#define	UCDD_MEM_DDR_MVR_Y2                               94
#define	UCDD_MEM_DDR_MVR_Y3                               95
#define	UCDD_MEM_DDR_MVR_C0                               96
#define	UCDD_MEM_DDR_MVR_C1                               97
#define	UCDD_MEM_DDR_MVR_C2                               98
#define	UCDD_MEM_DDR_MVR_C3                               99
#define	UCDD_MEM_DDR_SVR0                                 100
#define	UCDD_MEM_DDR_SVR1                                 101
#define	UCDD_MEM_DDR_SVR2                                 102
#define	UCDD_MEM_DDR_SVR3                                 103
#define	UCDD_MEM_DDR_FILTER2_IPCONV                       104
#define	UCDD_MEM_DDR_FILTER1Y                             105
#define	UCDD_MEM_DDR_FILTER1C                             106
#define	UCDD_MEM_DDR_FILTER2Y                             107
#define	UCDD_MEM_DDR_FILTER2C                             108
#define	UCDD_MEM_DDR_FILTEREXIVY                          109
#define	UCDD_MEM_DDR_FILTEREXIVC                          110
#define	UCDD_MEM_DDR_FILTER2ND_A                          111
#define	UCDD_MEM_DDR_FILTER2ND_B                          112
#define	UCDD_MEM_DDR_IOSD0_0                              113
#define	UCDD_MEM_DDR_IOSD0_1                              114
#define	UCDD_MEM_DDR_IOSD0_2                              115
#define	UCDD_MEM_DDR_IOSD1_0                              116
#define	UCDD_MEM_DDR_IOSD1_1                              117
#define	UCDD_MEM_DDR_IOSD1_2                              118
#define	UCDD_MEM_DDR_CURSOR_0                             119
#define	UCDD_MEM_DDR_CURSOR_1                             120
#define	UCDD_MEM_DDR_CLUT0                                121
#define	UCDD_MEM_DDR_CLUT1                                122
#define	UCDD_MEM_DDR_CLUT2                                123
#define	UCDD_MEM_DDR_CLUT3                                124
#define	UCDD_MEM_DDR_CLUT4                                125
#define	UCDD_MEM_DDR_CLUT5                                126
#define	UCDD_MEM_DDR_LOSD0_0                              127
#define	UCDD_MEM_DDR_LOSD0_0_L                            128
#define	UCDD_MEM_DDR_LOSD0_0_R                            129
#define	UCDD_MEM_DDR_LOSD0_1                              130
#define	UCDD_MEM_DDR_LOSD0_1_L                            131
#define	UCDD_MEM_DDR_LOSD0_1_R                            132
#define	UCDD_MEM_DDR_LOSD0_2                              133
#define	UCDD_MEM_DDR_LOSD0_2_L                            134
#define	UCDD_MEM_DDR_LOSD0_2_R                            135
#define	UCDD_MEM_DDR_LOSD1_0                              136
#define	UCDD_MEM_DDR_LOSD1_0_L                            137
#define	UCDD_MEM_DDR_LOSD1_0_R                            138
#define	UCDD_MEM_DDR_LOSD1_1                              139
#define	UCDD_MEM_DDR_LOSD1_1_L                            140
#define	UCDD_MEM_DDR_LOSD1_1_R                            141
#define	UCDD_MEM_DDR_LOSD1_2                              142
#define	UCDD_MEM_DDR_LOSD1_2_L                            143
#define	UCDD_MEM_DDR_LOSD1_2_R                            144
#define	UCDD_MEM_DDR_VOSD                                 145
#define	UCDD_MEM_DDR_DDI_GPU                              146
#define	UCDD_MEM_DDR_LOSD_BUFFER                          147
#define	UCDD_MEM_DDR_EPG_BUFFER                           148
#define	UCDD_MEM_DDR_AJAX_BUFFER0                         149
#define	UCDD_MEM_DDR_AJAX_BUFFER1                         150
#define	UCDD_MEM_DDR_IOSDB0                               151
#define	UCDD_MEM_DDR_IOSDB1                               152
#define	UCDD_MEM_DDR_IOSDC0                               153
#define	UCDD_MEM_DDR_IOSDC1                               154
#define	UCDD_MEM_DDR_IOSDD0                               155
#define	UCDD_MEM_DDR_IOSDD1                               156
#define	UCDD_MEM_DDR_PG                                   157
#define	UCDD_MEM_DDR_PGCBB                                158
#define	UCDD_MEM_DDR_PGCBB0                               159
#define	UCDD_MEM_DDR_PGCBB1                               160
#define	UCDD_MEM_DDR_PGCDBB                               161
#define	UCDD_MEM_DDR_PGCDBB0                              162
#define	UCDD_MEM_DDR_PGCDBB1                              163
#define	UCDD_MEM_DDR_PGOBTABLE                            164
#define	UCDD_MEM_DDR_PGOBTABLE0                           165
#define	UCDD_MEM_DDR_PGOBTABLE0_0                         166
#define	UCDD_MEM_DDR_PGOBTABLE0_1                         167
#define	UCDD_MEM_DDR_PGOBTABLE1                           168
#define	UCDD_MEM_DDR_PGOBTABLE1_0                         169
#define	UCDD_MEM_DDR_PGOBTABLE1_1                         170
#define	UCDD_MEM_DDR_PGOB                                 171
#define	UCDD_MEM_DDR_PGOB0                                172
#define	UCDD_MEM_DDR_PGOB1                                173
#define	UCDD_MEM_DDR_PGPBTABLE                            174
#define	UCDD_MEM_DDR_PGPBTABLE0                           175
#define	UCDD_MEM_DDR_PGPBTABLE0_0                         176
#define	UCDD_MEM_DDR_PGPBTABLE0_1                         177
#define	UCDD_MEM_DDR_PGPBTABLE1                           178
#define	UCDD_MEM_DDR_PGPBTABLE1_0                         179
#define	UCDD_MEM_DDR_PGPBTABLE1_1                         180
#define	UCDD_MEM_DDR_IOSDA0                               181
#define	UCDD_MEM_DDR_IOSDA1                               182
#define	UCDD_MEM_DDR_IG                                   183
#define	UCDD_MEM_DDR_IGCBB                                184
#define	UCDD_MEM_DDR_IGCBB0                               185
#define	UCDD_MEM_DDR_IGCBB0_0                             186
#define	UCDD_MEM_DDR_IGCBB0_1                             187
#define	UCDD_MEM_DDR_IGCBB1                               188
#define	UCDD_MEM_DDR_IGCBB1_0                             189
#define	UCDD_MEM_DDR_IGCBB1_1                             190
#define	UCDD_MEM_DDR_IGCDBB                               191
#define	UCDD_MEM_DDR_IGCDBB0                              192
#define	UCDD_MEM_DDR_IGCDBB1                              193
#define	UCDD_MEM_DDR_IGOBTABLE                            194
#define	UCDD_MEM_DDR_IGOBTABLE0                           195
#define	UCDD_MEM_DDR_IGOBTABLE0_0                         196
#define	UCDD_MEM_DDR_IGOBTABLE0_1                         197
#define	UCDD_MEM_DDR_IGOBTABLE1                           198
#define	UCDD_MEM_DDR_IGOBTABLE1_0                         199
#define	UCDD_MEM_DDR_IGOBTABLE1_1                         200
#define	UCDD_MEM_DDR_IGDOB                                201
#define	UCDD_MEM_DDR_IGDOB0                               202
#define	UCDD_MEM_DDR_IGDOB0_0                             203
#define	UCDD_MEM_DDR_IGDOB0_1                             204
#define	UCDD_MEM_DDR_IGDOB1                               205
#define	UCDD_MEM_DDR_IGDOB1_0                             206
#define	UCDD_MEM_DDR_IGDOB1_1                             207
#define	UCDD_MEM_DDR_IGPBTABLE                            208
#define	UCDD_MEM_DDR_IGPBTABLE0                           209
#define	UCDD_MEM_DDR_IGPBTABLE0_0                         210
#define	UCDD_MEM_DDR_IGPBTABLE0_1                         211
#define	UCDD_MEM_DDR_IGPBTABLE1                           212
#define	UCDD_MEM_DDR_IGPBTABLE1_0                         213
#define	UCDD_MEM_DDR_IGPBTABLE1_1                         214
#define	UCDD_MEM_DDR_IGCBTABLE                            215
#define	UCDD_MEM_DDR_IGCBTABLE0                           216
#define	UCDD_MEM_DDR_IGCBTABLE1                           217
#define	UCDD_MEM_DDR_STILL0_Y0                            218
#define	UCDD_MEM_DDR_STILL0_C0                            219
#define	UCDD_MEM_DDR_STILL0_Y1                            220
#define	UCDD_MEM_DDR_STILL0_C1                            221
#define	UCDD_MEM_DDR_STILL1_Y0                            222
#define	UCDD_MEM_DDR_STILL1_C0                            223
#define	UCDD_MEM_DDR_STILL1_Y1                            224
#define	UCDD_MEM_DDR_STILL1_C1                            225
#define	UCDD_MEM_DDR_BDJIMGAUD                            226
#define	UCDD_MEM_DDR_THUMBNAIL                            227
#define	UCDD_MEM_DDR_RLE                                  228
#define	UCDD_MEM_DDR_SPUBB0                               229
#define	UCDD_MEM_DDR_SPUBB1                               230
#define	UCDD_MEM_DDR_SPU0                                 231
#define	UCDD_MEM_DDR_SPU1                                 232
#define	UCDD_MEM_DDR_SVBB0                                233
#define	UCDD_MEM_DDR_VBB0                                 234
#define	UCDD_MEM_DDR_VDB0                                 235
#define	UCDD_MEM_DDR_PARAM0                               236
#define	UCDD_MEM_DDR_NONVCLPRM0                           237
#define	UCDD_MEM_DDR_SLHPRM0                              238
#define	UCDD_MEM_DDR_SEIMSG0                              239
#define	UCDD_MEM_DDR_DPBINFOPRM0                          240
#define	UCDD_MEM_DDR_RPLPRM0                              241
#define	UCDD_MEM_DDR_QMTRXPRM0                            242
#define	UCDD_MEM_DDR_DECINFOPRM0                          243
#define	UCDD_MEM_DDR_ACODECPRM0                           244
#define	UCDD_MEM_DDR_MKVPRM0                              245
#define	UCDD_MEM_DDR_MP4PRM0                              246
#define	UCDD_MEM_DDR_SWWORKBUFF0                          247
#define	UCDD_MEM_DDR_SUBSETSPS0                           248
#define	UCDD_MEM_DDR_SVBB1                                249
#define	UCDD_MEM_DDR_VBB1                                 250
#define	UCDD_MEM_DDR_VDB1                                 251
#define	UCDD_MEM_DDR_PARAM1                               252
#define	UCDD_MEM_DDR_NONVCLPRM1                           253
#define	UCDD_MEM_DDR_SLHPRM1                              254
#define	UCDD_MEM_DDR_SEIMSG1                              255
#define	UCDD_MEM_DDR_DPBINFOPRM1                          256
#define	UCDD_MEM_DDR_RPLPRM1                              257
#define	UCDD_MEM_DDR_QMTRXPRM1                            258
#define	UCDD_MEM_DDR_DECINFOPRM1                          259
#define	UCDD_MEM_DDR_ACODECPRM1                           260
#define	UCDD_MEM_DDR_MKVPRM1                              261
#define	UCDD_MEM_DDR_MP4PRM1                              262
#define	UCDD_MEM_DDR_SWWORKBUFF1                          263
#define	UCDD_MEM_DDR_SUBSETSPS1                           264
#define	UCDD_MEM_DDR_SVBB2                                265
#define	UCDD_MEM_DDR_SCEB0                                266
#define	UCDD_MEM_DDR_VBB2                                 267
#define	UCDD_MEM_DDR_VDB2                                 268
#define	UCDD_MEM_DDR_PARAM2                               269
#define	UCDD_MEM_DDR_NONVCLPRM2                           270
#define	UCDD_MEM_DDR_SLHPRM2                              271
#define	UCDD_MEM_DDR_SEIMSG2                              272
#define	UCDD_MEM_DDR_DPBINFOPRM2                          273
#define	UCDD_MEM_DDR_RPLPRM2                              274
#define	UCDD_MEM_DDR_QMTRXPRM2                            275
#define	UCDD_MEM_DDR_DECINFOPRM2                          276
#define	UCDD_MEM_DDR_ACODECPRM2                           277
#define	UCDD_MEM_DDR_MKVPRM2                              278
#define	UCDD_MEM_DDR_MP4PRM2                              279
#define	UCDD_MEM_DDR_SWWORKBUFF2                          280
#define	UCDD_MEM_DDR_SUBSETSPS2                           281
#define	UCDD_MEM_DDR_SW_DECODER                           282
#define	UCDD_MEM_DDR_COLPIC0                              283
#define	UCDD_MEM_DDR_COLPIC1                              284
#define	UCDD_MEM_DDR_COLPIC2                              285
#define	UCDD_MEM_DDR_VEB0                                 286
#define	UCDD_MEM_DDR_VEBPRE0                              287
#define	UCDD_MEM_DDR_ENCCOLPIC0                           288
#define	UCDD_MEM_DDR_ENCPARAM0                            289
#define	UCDD_MEM_DDR_ENCDPB0                              290
#define	UCDD_MEM_DDR_ENCDPB0_Y0                           291
#define	UCDD_MEM_DDR_ENCDPB0_Y1                           292
#define	UCDD_MEM_DDR_ENCDPB0_Y2                           293
#define	UCDD_MEM_DDR_ENCDPB0_C0                           294
#define	UCDD_MEM_DDR_ENCDPB0_C1                           295
#define	UCDD_MEM_DDR_ENCDPB0_C2                           296
#define	UCDD_MEM_DDR_VEB1                                 297
#define	UCDD_MEM_DDR_VEBPRE1                              298
#define	UCDD_MEM_DDR_ENCCOLPIC1                           299
#define	UCDD_MEM_DDR_ENCPARAM1                            300
#define	UCDD_MEM_DDR_ENCDPB1                              301
#define	UCDD_MEM_DDR_ENCDPB1_Y0                           302
#define	UCDD_MEM_DDR_ENCDPB1_Y1                           303
#define	UCDD_MEM_DDR_ENCDPB1_Y2                           304
#define	UCDD_MEM_DDR_ENCDPB1_C0                           305
#define	UCDD_MEM_DDR_ENCDPB1_C1                           306
#define	UCDD_MEM_DDR_ENCDPB1_C2                           307
#define	UCDD_MEM_DDR_DDR_CH1                              308
#define	UCDD_MEM_DDR_FRAMEBUF0                            309
#define	UCDD_MEM_DDR_FRAMEBUF0_Y0                         310
#define	UCDD_MEM_DDR_FRAMEBUF0_Y1                         311
#define	UCDD_MEM_DDR_FRAMEBUF0_Y2                         312
#define	UCDD_MEM_DDR_FRAMEBUF0_Y3                         313
#define	UCDD_MEM_DDR_FRAMEBUF0_Y4                         314
#define	UCDD_MEM_DDR_FRAMEBUF0_Y5                         315
#define	UCDD_MEM_DDR_FRAMEBUF0_Y6                         316
#define	UCDD_MEM_DDR_FRAMEBUF0_Y7                         317
#define	UCDD_MEM_DDR_FRAMEBUF0_Y8                         318
#define	UCDD_MEM_DDR_FRAMEBUF0_Y9                         319
#define	UCDD_MEM_DDR_FRAMEBUF0_Y10                        320
#define	UCDD_MEM_DDR_FRAMEBUF0_Y11                        321
#define	UCDD_MEM_DDR_FRAMEBUF0_Y12                        322
#define	UCDD_MEM_DDR_FRAMEBUF0_Y13                        323
#define	UCDD_MEM_DDR_FRAMEBUF0_Y14                        324
#define	UCDD_MEM_DDR_FRAMEBUF0_Y15                        325
#define	UCDD_MEM_DDR_FRAMEBUF0_Y16                        326
#define	UCDD_MEM_DDR_FRAMEBUF0_Y17                        327
#define	UCDD_MEM_DDR_FRAMEBUF0_Y18                        328
#define	UCDD_MEM_DDR_FRAMEBUF0_Y19                        329
#define	UCDD_MEM_DDR_FRAMEBUF0_C0                         330
#define	UCDD_MEM_DDR_FRAMEBUF0_C1                         331
#define	UCDD_MEM_DDR_FRAMEBUF0_C2                         332
#define	UCDD_MEM_DDR_FRAMEBUF0_C3                         333
#define	UCDD_MEM_DDR_FRAMEBUF0_C4                         334
#define	UCDD_MEM_DDR_FRAMEBUF0_C5                         335
#define	UCDD_MEM_DDR_FRAMEBUF0_C6                         336
#define	UCDD_MEM_DDR_FRAMEBUF0_C7                         337
#define	UCDD_MEM_DDR_FRAMEBUF0_C8                         338
#define	UCDD_MEM_DDR_FRAMEBUF0_C9                         339
#define	UCDD_MEM_DDR_FRAMEBUF0_C10                        340
#define	UCDD_MEM_DDR_FRAMEBUF0_C11                        341
#define	UCDD_MEM_DDR_FRAMEBUF0_C12                        342
#define	UCDD_MEM_DDR_FRAMEBUF0_C13                        343
#define	UCDD_MEM_DDR_FRAMEBUF0_C14                        344
#define	UCDD_MEM_DDR_FRAMEBUF0_C15                        345
#define	UCDD_MEM_DDR_FRAMEBUF0_C16                        346
#define	UCDD_MEM_DDR_FRAMEBUF0_C17                        347
#define	UCDD_MEM_DDR_FRAMEBUF0_C18                        348
#define	UCDD_MEM_DDR_FRAMEBUF0_C19                        349
#define	UCDD_MEM_DDR_FM_STILL0_Y                          350
#define	UCDD_MEM_DDR_FM_STILL0_C                          351
#define	UCDD_MEM_DDR_BDJ_WORK                             352
#define	UCDD_MEM_DDR_DV0                                  353
#define	UCDD_MEM_DDR_FRAMEBUF1                            354
#define	UCDD_MEM_DDR_FRAMEBUF1_Y0                         355
#define	UCDD_MEM_DDR_FRAMEBUF1_Y1                         356
#define	UCDD_MEM_DDR_FRAMEBUF1_Y2                         357
#define	UCDD_MEM_DDR_FRAMEBUF1_Y3                         358
#define	UCDD_MEM_DDR_FRAMEBUF1_Y4                         359
#define	UCDD_MEM_DDR_FRAMEBUF1_Y5                         360
#define	UCDD_MEM_DDR_FRAMEBUF1_Y6                         361
#define	UCDD_MEM_DDR_FRAMEBUF1_Y7                         362
#define	UCDD_MEM_DDR_FRAMEBUF1_Y8                         363
#define	UCDD_MEM_DDR_FRAMEBUF1_Y9                         364
#define	UCDD_MEM_DDR_FRAMEBUF1_Y10                        365
#define	UCDD_MEM_DDR_FRAMEBUF1_Y11                        366
#define	UCDD_MEM_DDR_FRAMEBUF1_Y12                        367
#define	UCDD_MEM_DDR_FRAMEBUF1_Y13                        368
#define	UCDD_MEM_DDR_FRAMEBUF1_Y14                        369
#define	UCDD_MEM_DDR_FRAMEBUF1_Y15                        370
#define	UCDD_MEM_DDR_FRAMEBUF1_Y16                        371
#define	UCDD_MEM_DDR_FRAMEBUF1_Y17                        372
#define	UCDD_MEM_DDR_FRAMEBUF1_Y18                        373
#define	UCDD_MEM_DDR_FRAMEBUF1_Y19                        374
#define	UCDD_MEM_DDR_FRAMEBUF1_C0                         375
#define	UCDD_MEM_DDR_FRAMEBUF1_C1                         376
#define	UCDD_MEM_DDR_FRAMEBUF1_C2                         377
#define	UCDD_MEM_DDR_FRAMEBUF1_C3                         378
#define	UCDD_MEM_DDR_FRAMEBUF1_C4                         379
#define	UCDD_MEM_DDR_FRAMEBUF1_C5                         380
#define	UCDD_MEM_DDR_FRAMEBUF1_C6                         381
#define	UCDD_MEM_DDR_FRAMEBUF1_C7                         382
#define	UCDD_MEM_DDR_FRAMEBUF1_C8                         383
#define	UCDD_MEM_DDR_FRAMEBUF1_C9                         384
#define	UCDD_MEM_DDR_FRAMEBUF1_C10                        385
#define	UCDD_MEM_DDR_FRAMEBUF1_C11                        386
#define	UCDD_MEM_DDR_FRAMEBUF1_C12                        387
#define	UCDD_MEM_DDR_FRAMEBUF1_C13                        388
#define	UCDD_MEM_DDR_FRAMEBUF1_C14                        389
#define	UCDD_MEM_DDR_FRAMEBUF1_C15                        390
#define	UCDD_MEM_DDR_FRAMEBUF1_C16                        391
#define	UCDD_MEM_DDR_FRAMEBUF1_C17                        392
#define	UCDD_MEM_DDR_FRAMEBUF1_C18                        393
#define	UCDD_MEM_DDR_FRAMEBUF1_C19                        394
#define	UCDD_MEM_DDR_AIOF                                 395
#define	UCDD_MEM_DDR_DV1                                  396
#define	UCDD_MEM_DDR_SNIP_Y                               397
#define	UCDD_MEM_DDR_SNIP_C                               398
#define	UCDD_MEM_DDR_ME0                                  399
#define	UCDD_MEM_DDR_ENCBUF0                              400
#define	UCDD_MEM_DDR_ENCBUF0_Y0                           401
#define	UCDD_MEM_DDR_ENCBUF0_Y1                           402
#define	UCDD_MEM_DDR_ENCBUF0_Y2                           403
#define	UCDD_MEM_DDR_ENCBUF0_Y3                           404
#define	UCDD_MEM_DDR_ENCBUF0_Y4                           405
#define	UCDD_MEM_DDR_ENCBUF0_Y5                           406
#define	UCDD_MEM_DDR_ENCBUF0_Y6                           407
#define	UCDD_MEM_DDR_ENCBUF0_C0                           408
#define	UCDD_MEM_DDR_ENCBUF0_C1                           409
#define	UCDD_MEM_DDR_ENCBUF0_C2                           410
#define	UCDD_MEM_DDR_ENCBUF0_C3                           411
#define	UCDD_MEM_DDR_ENCBUF0_C4                           412
#define	UCDD_MEM_DDR_ENCBUF0_C5                           413
#define	UCDD_MEM_DDR_ENCBUF0_C6                           414
#define	UCDD_MEM_DDR_ME1                                  415
#define	UCDD_MEM_DDR_ENCBUF1                              416
#define	UCDD_MEM_DDR_ENCBUF1_Y0                           417
#define	UCDD_MEM_DDR_ENCBUF1_Y1                           418
#define	UCDD_MEM_DDR_ENCBUF1_Y2                           419
#define	UCDD_MEM_DDR_ENCBUF1_Y3                           420
#define	UCDD_MEM_DDR_ENCBUF1_Y4                           421
#define	UCDD_MEM_DDR_ENCBUF1_Y5                           422
#define	UCDD_MEM_DDR_ENCBUF1_Y6                           423
#define	UCDD_MEM_DDR_ENCBUF1_C0                           424
#define	UCDD_MEM_DDR_ENCBUF1_C1                           425
#define	UCDD_MEM_DDR_ENCBUF1_C2                           426
#define	UCDD_MEM_DDR_ENCBUF1_C3                           427
#define	UCDD_MEM_DDR_ENCBUF1_C4                           428
#define	UCDD_MEM_DDR_ENCBUF1_C5                           429
#define	UCDD_MEM_DDR_ENCBUF1_C6                           430
#define	UCDD_MEM_DDR_JPEG_SW_DEC_WORK_0                   431
#define	UCDD_MEM_DDR_JPEG_DEC_OUTBUF_Y0                   432
#define	UCDD_MEM_DDR_JPEG_DEC_OUTBUF_C0                   433
#define	UCDD_MEM_DDR_JPEG_DEC_OUTBUF_Y1                   434
#define	UCDD_MEM_DDR_JPEG_DEC_OUTBUF_C1                   435
#define	UCDD_MEM_DDR_JPEG_TRANS_BUF_Y0                    436
#define	UCDD_MEM_DDR_JPEG_TRANS_BUF_C0                    437
#define	UCDD_MEM_DDR_JPEG_LANCZOS_BUF                     438
#define	UCDD_MEM_DDR_JPEG_HW_DEC_RESULT_Y                 439
#define	UCDD_MEM_DDR_JPEG_HW_DEC_RESULT_C                 440
#define	UCDD_MEM_DDR_JPEG_HW_DEC_RESULT0                  441
#define	UCDD_MEM_DDR_JPEG_HW_DEC_RESULT1                  442
#define	UCDD_MEM_NOT_USED                                 443
#define	UCDD_MEM_N                                        444

#define	AVCC_MEM_RLE1                                     UCDD_MEM_RLE1
#define	AVCC_MEM_RLE2                                     UCDD_MEM_RLE2
#define	AVCC_MEM_RLEIOP0                                  UCDD_MEM_RLEIOP0
#define	AVCC_MEM_RLEIOP1                                  UCDD_MEM_RLEIOP1
#define	AVCC_MEM_RLEDMAC                                  UCDD_MEM_RLEDMAC
#define	AVCC_MEM_FDMAC                                    UCDD_MEM_FDMAC
#define	AVCC_MEM_SYS                                      UCDD_MEM_SYS
#define	AVCC_MEM_HCM                                      UCDD_MEM_HCM
#define	AVCC_MEM_HSC                                      UCDD_MEM_HSC
#define	AVCC_MEM_AIOF                                     UCDD_MEM_AIOF
#define	AVCC_MEM_IPR                                      UCDD_MEM_IPR
#define	AVCC_MEM_VOUT                                     UCDD_MEM_VOUT
#define	AVCC_MEM_HOSTIOP                                  UCDD_MEM_HOSTIOP
#define	AVCC_MEM_HASI                                     UCDD_MEM_HASI
#define	AVCC_MEM_LOSD                                     UCDD_MEM_LOSD
#define	AVCC_MEM_AVCORE                                   UCDD_MEM_AVCORE
#define	AVCC_MEM_SOCGLUE                                  UCDD_MEM_SOCGLUE
#define	AVCC_MEM_DDR_DDR_CH0                              UCDD_MEM_DDR_DDR_CH0
#define	AVCC_MEM_DDR_INST_PARAM                           UCDD_MEM_DDR_INST_PARAM
#define	AVCC_MEM_DDR_DPPINSTST_0_H264                     UCDD_MEM_DDR_DPPINSTST_0_H264
#define	AVCC_MEM_DDR_HCMDDR_OFFSET                        UCDD_MEM_DDR_HCMDDR_OFFSET
#define	AVCC_MEM_DDR_JPEG_TABLE0                          UCDD_MEM_DDR_JPEG_TABLE0
#define	AVCC_MEM_DDR_JPEG_HUFFMAN_TABLE0                  UCDD_MEM_DDR_JPEG_HUFFMAN_TABLE0
#define	AVCC_MEM_DDR_JPEG_Q_TABLE0                        UCDD_MEM_DDR_JPEG_Q_TABLE0
#define	AVCC_MEM_DDR_JPEG_TABLE1                          UCDD_MEM_DDR_JPEG_TABLE1
#define	AVCC_MEM_DDR_JPEG_HUFFMAN_TABLE1                  UCDD_MEM_DDR_JPEG_HUFFMAN_TABLE1
#define	AVCC_MEM_DDR_JPEG_Q_TABLE1                        UCDD_MEM_DDR_JPEG_Q_TABLE1
#define	AVCC_MEM_DDR_UDLWORK                              UCDD_MEM_DDR_UDLWORK
#define	AVCC_MEM_DDR_SABB0                                UCDD_MEM_DDR_SABB0
#define	AVCC_MEM_DDR_SABB1                                UCDD_MEM_DDR_SABB1
#define	AVCC_MEM_DDR_SABB2                                UCDD_MEM_DDR_SABB2
#define	AVCC_MEM_DDR_SAE2B0                               UCDD_MEM_DDR_SAE2B0
#define	AVCC_MEM_DDR_ADB                                  UCDD_MEM_DDR_ADB
#define	AVCC_MEM_DDR_ABB0                                 UCDD_MEM_DDR_ABB0
#define	AVCC_MEM_DDR_ABB1                                 UCDD_MEM_DDR_ABB1
#define	AVCC_MEM_DDR_ABB2                                 UCDD_MEM_DDR_ABB2
#define	AVCC_MEM_DDR_AOB                                  UCDD_MEM_DDR_AOB
#define	AVCC_MEM_DDR_AOB0                                 UCDD_MEM_DDR_AOB0
#define	AVCC_MEM_DDR_AOB1                                 UCDD_MEM_DDR_AOB1
#define	AVCC_MEM_DDR_AOB2                                 UCDD_MEM_DDR_AOB2
#define	AVCC_MEM_DDR_AIB                                  UCDD_MEM_DDR_AIB
#define	AVCC_MEM_DDR_AIB0                                 UCDD_MEM_DDR_AIB0
#define	AVCC_MEM_DDR_AIB1                                 UCDD_MEM_DDR_AIB1
#define	AVCC_MEM_DDR_REMASTER0                            UCDD_MEM_DDR_REMASTER0
#define	AVCC_MEM_DDR_REMASTER1                            UCDD_MEM_DDR_REMASTER1
#define	AVCC_MEM_DDR_HBASSPARAM0                          UCDD_MEM_DDR_HBASSPARAM0
#define	AVCC_MEM_DDR_HBASSPARAM1                          UCDD_MEM_DDR_HBASSPARAM1
#define	AVCC_MEM_DDR_PCMMIX0                              UCDD_MEM_DDR_PCMMIX0
#define	AVCC_MEM_DDR_PCMMIX1                              UCDD_MEM_DDR_PCMMIX1
#define	AVCC_MEM_DDR_PCMMIX2                              UCDD_MEM_DDR_PCMMIX2
#define	AVCC_MEM_DDR_BRFILTERCOEF0                        UCDD_MEM_DDR_BRFILTERCOEF0
#define	AVCC_MEM_DDR_BRFILTERCOEF1                        UCDD_MEM_DDR_BRFILTERCOEF1
#define	AVCC_MEM_DDR_BRFILTERCOEF2                        UCDD_MEM_DDR_BRFILTERCOEF2
#define	AVCC_MEM_DDR_AUDMIXM2A                            UCDD_MEM_DDR_AUDMIXM2A
#define	AVCC_MEM_DDR_AUDMIXM2B                            UCDD_MEM_DDR_AUDMIXM2B
#define	AVCC_MEM_DDR_AUDMIXM2C                            UCDD_MEM_DDR_AUDMIXM2C
#define	AVCC_MEM_DDR_AUDMIXM2D                            UCDD_MEM_DDR_AUDMIXM2D
#define	AVCC_MEM_DDR_AUDMIXM2E                            UCDD_MEM_DDR_AUDMIXM2E
#define	AVCC_MEM_DDR_AUDMIXM2F                            UCDD_MEM_DDR_AUDMIXM2F
#define	AVCC_MEM_DDR_AUDMIXM2G                            UCDD_MEM_DDR_AUDMIXM2G
#define	AVCC_MEM_DDR_AUDMIXM2H                            UCDD_MEM_DDR_AUDMIXM2H
#define	AVCC_MEM_DDR_AEB0                                 UCDD_MEM_DDR_AEB0
#define	AVCC_MEM_DDR_AEB1                                 UCDD_MEM_DDR_AEB1
#define	AVCC_MEM_DDR_TRANS_AEB0                           UCDD_MEM_DDR_TRANS_AEB0
#define	AVCC_MEM_DDR_TRANS_AEB1                           UCDD_MEM_DDR_TRANS_AEB1
#define	AVCC_MEM_DDR_SIT_AND_PMT0                         UCDD_MEM_DDR_SIT_AND_PMT0
#define	AVCC_MEM_DDR_SIT_AND_PMT1                         UCDD_MEM_DDR_SIT_AND_PMT1
#define	AVCC_MEM_DDR_APTS_TABLE_DEC                       UCDD_MEM_DDR_APTS_TABLE_DEC
#define	AVCC_MEM_DDR_APTS_TABLE_DEC0                      UCDD_MEM_DDR_APTS_TABLE_DEC0
#define	AVCC_MEM_DDR_APTS_TABLE_DEC1                      UCDD_MEM_DDR_APTS_TABLE_DEC1
#define	AVCC_MEM_DDR_APTS_TABLE_DEC2                      UCDD_MEM_DDR_APTS_TABLE_DEC2
#define	AVCC_MEM_DDR_RMAACFRM0                            UCDD_MEM_DDR_RMAACFRM0
#define	AVCC_MEM_DDR_RMAACFRM1                            UCDD_MEM_DDR_RMAACFRM1
#define	AVCC_MEM_DDR_RMAACFRM2                            UCDD_MEM_DDR_RMAACFRM2
#define	AVCC_MEM_DDR_ADECINF0                             UCDD_MEM_DDR_ADECINF0
#define	AVCC_MEM_DDR_ADECINF1                             UCDD_MEM_DDR_ADECINF1
#define	AVCC_MEM_DDR_ADECINF2                             UCDD_MEM_DDR_ADECINF2
#define	AVCC_MEM_DDR_APTS_TABLE0                          UCDD_MEM_DDR_APTS_TABLE0
#define	AVCC_MEM_DDR_APTS_TABLE1                          UCDD_MEM_DDR_APTS_TABLE1
#define	AVCC_MEM_DDR_SDCARD                               UCDD_MEM_DDR_SDCARD
#define	AVCC_MEM_DDR_AE1B0                                UCDD_MEM_DDR_AE1B0
#define	AVCC_MEM_DDR_AE2B0                                UCDD_MEM_DDR_AE2B0
#define	AVCC_MEM_DDR_CEB0                                 UCDD_MEM_DDR_CEB0
#define	AVCC_MEM_DDR_AE1PTS_TABLE0                        UCDD_MEM_DDR_AE1PTS_TABLE0
#define	AVCC_MEM_DDR_AE2PTS_TABLE0                        UCDD_MEM_DDR_AE2PTS_TABLE0
#define	AVCC_MEM_DDR_CEPTS_TABLE0                         UCDD_MEM_DDR_CEPTS_TABLE0
#define	AVCC_MEM_DDR_FCARDADDR                            UCDD_MEM_DDR_FCARDADDR
#define	AVCC_MEM_DDR_COEF                                 UCDD_MEM_DDR_COEF
#define	AVCC_MEM_DDR_FCCOEF                               UCDD_MEM_DDR_FCCOEF
#define	AVCC_MEM_DDR_TELETEXT                             UCDD_MEM_DDR_TELETEXT
#define	AVCC_MEM_DDR_MNIP_Y                               UCDD_MEM_DDR_MNIP_Y
#define	AVCC_MEM_DDR_MNIP_C                               UCDD_MEM_DDR_MNIP_C
#define	AVCC_MEM_DDR_MVR_Y0                               UCDD_MEM_DDR_MVR_Y0
#define	AVCC_MEM_DDR_MVR_Y1                               UCDD_MEM_DDR_MVR_Y1
#define	AVCC_MEM_DDR_MVR_Y2                               UCDD_MEM_DDR_MVR_Y2
#define	AVCC_MEM_DDR_MVR_Y3                               UCDD_MEM_DDR_MVR_Y3
#define	AVCC_MEM_DDR_MVR_C0                               UCDD_MEM_DDR_MVR_C0
#define	AVCC_MEM_DDR_MVR_C1                               UCDD_MEM_DDR_MVR_C1
#define	AVCC_MEM_DDR_MVR_C2                               UCDD_MEM_DDR_MVR_C2
#define	AVCC_MEM_DDR_MVR_C3                               UCDD_MEM_DDR_MVR_C3
#define	AVCC_MEM_DDR_SVR0                                 UCDD_MEM_DDR_SVR0
#define	AVCC_MEM_DDR_SVR1                                 UCDD_MEM_DDR_SVR1
#define	AVCC_MEM_DDR_SVR2                                 UCDD_MEM_DDR_SVR2
#define	AVCC_MEM_DDR_SVR3                                 UCDD_MEM_DDR_SVR3
#define	AVCC_MEM_DDR_FILTER2_IPCONV                       UCDD_MEM_DDR_FILTER2_IPCONV
#define	AVCC_MEM_DDR_FILTER1Y                             UCDD_MEM_DDR_FILTER1Y
#define	AVCC_MEM_DDR_FILTER1C                             UCDD_MEM_DDR_FILTER1C
#define	AVCC_MEM_DDR_FILTER2Y                             UCDD_MEM_DDR_FILTER2Y
#define	AVCC_MEM_DDR_FILTER2C                             UCDD_MEM_DDR_FILTER2C
#define	AVCC_MEM_DDR_FILTEREXIVY                          UCDD_MEM_DDR_FILTEREXIVY
#define	AVCC_MEM_DDR_FILTEREXIVC                          UCDD_MEM_DDR_FILTEREXIVC
#define	AVCC_MEM_DDR_FILTER2ND_A                          UCDD_MEM_DDR_FILTER2ND_A
#define	AVCC_MEM_DDR_FILTER2ND_B                          UCDD_MEM_DDR_FILTER2ND_B
#define	AVCC_MEM_DDR_IOSD0_0                              UCDD_MEM_DDR_IOSD0_0
#define	AVCC_MEM_DDR_IOSD0_1                              UCDD_MEM_DDR_IOSD0_1
#define	AVCC_MEM_DDR_IOSD0_2                              UCDD_MEM_DDR_IOSD0_2
#define	AVCC_MEM_DDR_IOSD1_0                              UCDD_MEM_DDR_IOSD1_0
#define	AVCC_MEM_DDR_IOSD1_1                              UCDD_MEM_DDR_IOSD1_1
#define	AVCC_MEM_DDR_IOSD1_2                              UCDD_MEM_DDR_IOSD1_2
#define	AVCC_MEM_DDR_CURSOR_0                             UCDD_MEM_DDR_CURSOR_0
#define	AVCC_MEM_DDR_CURSOR_1                             UCDD_MEM_DDR_CURSOR_1
#define	AVCC_MEM_DDR_CLUT0                                UCDD_MEM_DDR_CLUT0
#define	AVCC_MEM_DDR_CLUT1                                UCDD_MEM_DDR_CLUT1
#define	AVCC_MEM_DDR_CLUT2                                UCDD_MEM_DDR_CLUT2
#define	AVCC_MEM_DDR_CLUT3                                UCDD_MEM_DDR_CLUT3
#define	AVCC_MEM_DDR_CLUT4                                UCDD_MEM_DDR_CLUT4
#define	AVCC_MEM_DDR_CLUT5                                UCDD_MEM_DDR_CLUT5
#define	AVCC_MEM_DDR_LOSD0_0                              UCDD_MEM_DDR_LOSD0_0
#define	AVCC_MEM_DDR_LOSD0_0_L                            UCDD_MEM_DDR_LOSD0_0_L
#define	AVCC_MEM_DDR_LOSD0_0_R                            UCDD_MEM_DDR_LOSD0_0_R
#define	AVCC_MEM_DDR_LOSD0_1                              UCDD_MEM_DDR_LOSD0_1
#define	AVCC_MEM_DDR_LOSD0_1_L                            UCDD_MEM_DDR_LOSD0_1_L
#define	AVCC_MEM_DDR_LOSD0_1_R                            UCDD_MEM_DDR_LOSD0_1_R
#define	AVCC_MEM_DDR_LOSD0_2                              UCDD_MEM_DDR_LOSD0_2
#define	AVCC_MEM_DDR_LOSD0_2_L                            UCDD_MEM_DDR_LOSD0_2_L
#define	AVCC_MEM_DDR_LOSD0_2_R                            UCDD_MEM_DDR_LOSD0_2_R
#define	AVCC_MEM_DDR_LOSD1_0                              UCDD_MEM_DDR_LOSD1_0
#define	AVCC_MEM_DDR_LOSD1_0_L                            UCDD_MEM_DDR_LOSD1_0_L
#define	AVCC_MEM_DDR_LOSD1_0_R                            UCDD_MEM_DDR_LOSD1_0_R
#define	AVCC_MEM_DDR_LOSD1_1                              UCDD_MEM_DDR_LOSD1_1
#define	AVCC_MEM_DDR_LOSD1_1_L                            UCDD_MEM_DDR_LOSD1_1_L
#define	AVCC_MEM_DDR_LOSD1_1_R                            UCDD_MEM_DDR_LOSD1_1_R
#define	AVCC_MEM_DDR_LOSD1_2                              UCDD_MEM_DDR_LOSD1_2
#define	AVCC_MEM_DDR_LOSD1_2_L                            UCDD_MEM_DDR_LOSD1_2_L
#define	AVCC_MEM_DDR_LOSD1_2_R                            UCDD_MEM_DDR_LOSD1_2_R
#define	AVCC_MEM_DDR_VOSD                                 UCDD_MEM_DDR_VOSD
#define	AVCC_MEM_DDR_DDI_GPU                              UCDD_MEM_DDR_DDI_GPU
#define	AVCC_MEM_DDR_LOSD_BUFFER                          UCDD_MEM_DDR_LOSD_BUFFER
#define	AVCC_MEM_DDR_EPG_BUFFER                           UCDD_MEM_DDR_EPG_BUFFER
#define	AVCC_MEM_DDR_AJAX_BUFFER0                         UCDD_MEM_DDR_AJAX_BUFFER0
#define	AVCC_MEM_DDR_AJAX_BUFFER1                         UCDD_MEM_DDR_AJAX_BUFFER1
#define	AVCC_MEM_DDR_IOSDB0                               UCDD_MEM_DDR_IOSDB0
#define	AVCC_MEM_DDR_IOSDB1                               UCDD_MEM_DDR_IOSDB1
#define	AVCC_MEM_DDR_IOSDC0                               UCDD_MEM_DDR_IOSDC0
#define	AVCC_MEM_DDR_IOSDC1                               UCDD_MEM_DDR_IOSDC1
#define	AVCC_MEM_DDR_IOSDD0                               UCDD_MEM_DDR_IOSDD0
#define	AVCC_MEM_DDR_IOSDD1                               UCDD_MEM_DDR_IOSDD1
#define	AVCC_MEM_DDR_PG                                   UCDD_MEM_DDR_PG
#define	AVCC_MEM_DDR_PGCBB                                UCDD_MEM_DDR_PGCBB
#define	AVCC_MEM_DDR_PGCBB0                               UCDD_MEM_DDR_PGCBB0
#define	AVCC_MEM_DDR_PGCBB1                               UCDD_MEM_DDR_PGCBB1
#define	AVCC_MEM_DDR_PGCDBB                               UCDD_MEM_DDR_PGCDBB
#define	AVCC_MEM_DDR_PGCDBB0                              UCDD_MEM_DDR_PGCDBB0
#define	AVCC_MEM_DDR_PGCDBB1                              UCDD_MEM_DDR_PGCDBB1
#define	AVCC_MEM_DDR_PGOBTABLE                            UCDD_MEM_DDR_PGOBTABLE
#define	AVCC_MEM_DDR_PGOBTABLE0                           UCDD_MEM_DDR_PGOBTABLE0
#define	AVCC_MEM_DDR_PGOBTABLE0_0                         UCDD_MEM_DDR_PGOBTABLE0_0
#define	AVCC_MEM_DDR_PGOBTABLE0_1                         UCDD_MEM_DDR_PGOBTABLE0_1
#define	AVCC_MEM_DDR_PGOBTABLE1                           UCDD_MEM_DDR_PGOBTABLE1
#define	AVCC_MEM_DDR_PGOBTABLE1_0                         UCDD_MEM_DDR_PGOBTABLE1_0
#define	AVCC_MEM_DDR_PGOBTABLE1_1                         UCDD_MEM_DDR_PGOBTABLE1_1
#define	AVCC_MEM_DDR_PGOB                                 UCDD_MEM_DDR_PGOB
#define	AVCC_MEM_DDR_PGOB0                                UCDD_MEM_DDR_PGOB0
#define	AVCC_MEM_DDR_PGOB1                                UCDD_MEM_DDR_PGOB1
#define	AVCC_MEM_DDR_PGPBTABLE                            UCDD_MEM_DDR_PGPBTABLE
#define	AVCC_MEM_DDR_PGPBTABLE0                           UCDD_MEM_DDR_PGPBTABLE0
#define	AVCC_MEM_DDR_PGPBTABLE0_0                         UCDD_MEM_DDR_PGPBTABLE0_0
#define	AVCC_MEM_DDR_PGPBTABLE0_1                         UCDD_MEM_DDR_PGPBTABLE0_1
#define	AVCC_MEM_DDR_PGPBTABLE1                           UCDD_MEM_DDR_PGPBTABLE1
#define	AVCC_MEM_DDR_PGPBTABLE1_0                         UCDD_MEM_DDR_PGPBTABLE1_0
#define	AVCC_MEM_DDR_PGPBTABLE1_1                         UCDD_MEM_DDR_PGPBTABLE1_1
#define	AVCC_MEM_DDR_IOSDA0                               UCDD_MEM_DDR_IOSDA0
#define	AVCC_MEM_DDR_IOSDA1                               UCDD_MEM_DDR_IOSDA1
#define	AVCC_MEM_DDR_IG                                   UCDD_MEM_DDR_IG
#define	AVCC_MEM_DDR_IGCBB                                UCDD_MEM_DDR_IGCBB
#define	AVCC_MEM_DDR_IGCBB0                               UCDD_MEM_DDR_IGCBB0
#define	AVCC_MEM_DDR_IGCBB0_0                             UCDD_MEM_DDR_IGCBB0_0
#define	AVCC_MEM_DDR_IGCBB0_1                             UCDD_MEM_DDR_IGCBB0_1
#define	AVCC_MEM_DDR_IGCBB1                               UCDD_MEM_DDR_IGCBB1
#define	AVCC_MEM_DDR_IGCBB1_0                             UCDD_MEM_DDR_IGCBB1_0
#define	AVCC_MEM_DDR_IGCBB1_1                             UCDD_MEM_DDR_IGCBB1_1
#define	AVCC_MEM_DDR_IGCDBB                               UCDD_MEM_DDR_IGCDBB
#define	AVCC_MEM_DDR_IGCDBB0                              UCDD_MEM_DDR_IGCDBB0
#define	AVCC_MEM_DDR_IGCDBB1                              UCDD_MEM_DDR_IGCDBB1
#define	AVCC_MEM_DDR_IGOBTABLE                            UCDD_MEM_DDR_IGOBTABLE
#define	AVCC_MEM_DDR_IGOBTABLE0                           UCDD_MEM_DDR_IGOBTABLE0
#define	AVCC_MEM_DDR_IGOBTABLE0_0                         UCDD_MEM_DDR_IGOBTABLE0_0
#define	AVCC_MEM_DDR_IGOBTABLE0_1                         UCDD_MEM_DDR_IGOBTABLE0_1
#define	AVCC_MEM_DDR_IGOBTABLE1                           UCDD_MEM_DDR_IGOBTABLE1
#define	AVCC_MEM_DDR_IGOBTABLE1_0                         UCDD_MEM_DDR_IGOBTABLE1_0
#define	AVCC_MEM_DDR_IGOBTABLE1_1                         UCDD_MEM_DDR_IGOBTABLE1_1
#define	AVCC_MEM_DDR_IGDOB                                UCDD_MEM_DDR_IGDOB
#define	AVCC_MEM_DDR_IGDOB0                               UCDD_MEM_DDR_IGDOB0
#define	AVCC_MEM_DDR_IGDOB0_0                             UCDD_MEM_DDR_IGDOB0_0
#define	AVCC_MEM_DDR_IGDOB0_1                             UCDD_MEM_DDR_IGDOB0_1
#define	AVCC_MEM_DDR_IGDOB1                               UCDD_MEM_DDR_IGDOB1
#define	AVCC_MEM_DDR_IGDOB1_0                             UCDD_MEM_DDR_IGDOB1_0
#define	AVCC_MEM_DDR_IGDOB1_1                             UCDD_MEM_DDR_IGDOB1_1
#define	AVCC_MEM_DDR_IGPBTABLE                            UCDD_MEM_DDR_IGPBTABLE
#define	AVCC_MEM_DDR_IGPBTABLE0                           UCDD_MEM_DDR_IGPBTABLE0
#define	AVCC_MEM_DDR_IGPBTABLE0_0                         UCDD_MEM_DDR_IGPBTABLE0_0
#define	AVCC_MEM_DDR_IGPBTABLE0_1                         UCDD_MEM_DDR_IGPBTABLE0_1
#define	AVCC_MEM_DDR_IGPBTABLE1                           UCDD_MEM_DDR_IGPBTABLE1
#define	AVCC_MEM_DDR_IGPBTABLE1_0                         UCDD_MEM_DDR_IGPBTABLE1_0
#define	AVCC_MEM_DDR_IGPBTABLE1_1                         UCDD_MEM_DDR_IGPBTABLE1_1
#define	AVCC_MEM_DDR_IGCBTABLE                            UCDD_MEM_DDR_IGCBTABLE
#define	AVCC_MEM_DDR_IGCBTABLE0                           UCDD_MEM_DDR_IGCBTABLE0
#define	AVCC_MEM_DDR_IGCBTABLE1                           UCDD_MEM_DDR_IGCBTABLE1
#define	AVCC_MEM_DDR_STILL0_Y0                            UCDD_MEM_DDR_STILL0_Y0
#define	AVCC_MEM_DDR_STILL0_C0                            UCDD_MEM_DDR_STILL0_C0
#define	AVCC_MEM_DDR_STILL0_Y1                            UCDD_MEM_DDR_STILL0_Y1
#define	AVCC_MEM_DDR_STILL0_C1                            UCDD_MEM_DDR_STILL0_C1
#define	AVCC_MEM_DDR_STILL1_Y0                            UCDD_MEM_DDR_STILL1_Y0
#define	AVCC_MEM_DDR_STILL1_C0                            UCDD_MEM_DDR_STILL1_C0
#define	AVCC_MEM_DDR_STILL1_Y1                            UCDD_MEM_DDR_STILL1_Y1
#define	AVCC_MEM_DDR_STILL1_C1                            UCDD_MEM_DDR_STILL1_C1
#define	AVCC_MEM_DDR_BDJIMGAUD                            UCDD_MEM_DDR_BDJIMGAUD
#define	AVCC_MEM_DDR_THUMBNAIL                            UCDD_MEM_DDR_THUMBNAIL
#define	AVCC_MEM_DDR_RLE                                  UCDD_MEM_DDR_RLE
#define	AVCC_MEM_DDR_SPUBB0                               UCDD_MEM_DDR_SPUBB0
#define	AVCC_MEM_DDR_SPUBB1                               UCDD_MEM_DDR_SPUBB1
#define	AVCC_MEM_DDR_SPU0                                 UCDD_MEM_DDR_SPU0
#define	AVCC_MEM_DDR_SPU1                                 UCDD_MEM_DDR_SPU1
#define	AVCC_MEM_DDR_SVBB0                                UCDD_MEM_DDR_SVBB0
#define	AVCC_MEM_DDR_VBB0                                 UCDD_MEM_DDR_VBB0
#define	AVCC_MEM_DDR_VDB0                                 UCDD_MEM_DDR_VDB0
#define	AVCC_MEM_DDR_PARAM0                               UCDD_MEM_DDR_PARAM0
#define	AVCC_MEM_DDR_NONVCLPRM0                           UCDD_MEM_DDR_NONVCLPRM0
#define	AVCC_MEM_DDR_SLHPRM0                              UCDD_MEM_DDR_SLHPRM0
#define	AVCC_MEM_DDR_SEIMSG0                              UCDD_MEM_DDR_SEIMSG0
#define	AVCC_MEM_DDR_DPBINFOPRM0                          UCDD_MEM_DDR_DPBINFOPRM0
#define	AVCC_MEM_DDR_RPLPRM0                              UCDD_MEM_DDR_RPLPRM0
#define	AVCC_MEM_DDR_QMTRXPRM0                            UCDD_MEM_DDR_QMTRXPRM0
#define	AVCC_MEM_DDR_DECINFOPRM0                          UCDD_MEM_DDR_DECINFOPRM0
#define	AVCC_MEM_DDR_ACODECPRM0                           UCDD_MEM_DDR_ACODECPRM0
#define	AVCC_MEM_DDR_MKVPRM0                              UCDD_MEM_DDR_MKVPRM0
#define	AVCC_MEM_DDR_MP4PRM0                              UCDD_MEM_DDR_MP4PRM0
#define	AVCC_MEM_DDR_SWWORKBUFF0                          UCDD_MEM_DDR_SWWORKBUFF0
#define	AVCC_MEM_DDR_SUBSETSPS0                           UCDD_MEM_DDR_SUBSETSPS0
#define	AVCC_MEM_DDR_SVBB1                                UCDD_MEM_DDR_SVBB1
#define	AVCC_MEM_DDR_VBB1                                 UCDD_MEM_DDR_VBB1
#define	AVCC_MEM_DDR_VDB1                                 UCDD_MEM_DDR_VDB1
#define	AVCC_MEM_DDR_PARAM1                               UCDD_MEM_DDR_PARAM1
#define	AVCC_MEM_DDR_NONVCLPRM1                           UCDD_MEM_DDR_NONVCLPRM1
#define	AVCC_MEM_DDR_SLHPRM1                              UCDD_MEM_DDR_SLHPRM1
#define	AVCC_MEM_DDR_SEIMSG1                              UCDD_MEM_DDR_SEIMSG1
#define	AVCC_MEM_DDR_DPBINFOPRM1                          UCDD_MEM_DDR_DPBINFOPRM1
#define	AVCC_MEM_DDR_RPLPRM1                              UCDD_MEM_DDR_RPLPRM1
#define	AVCC_MEM_DDR_QMTRXPRM1                            UCDD_MEM_DDR_QMTRXPRM1
#define	AVCC_MEM_DDR_DECINFOPRM1                          UCDD_MEM_DDR_DECINFOPRM1
#define	AVCC_MEM_DDR_ACODECPRM1                           UCDD_MEM_DDR_ACODECPRM1
#define	AVCC_MEM_DDR_MKVPRM1                              UCDD_MEM_DDR_MKVPRM1
#define	AVCC_MEM_DDR_MP4PRM1                              UCDD_MEM_DDR_MP4PRM1
#define	AVCC_MEM_DDR_SWWORKBUFF1                          UCDD_MEM_DDR_SWWORKBUFF1
#define	AVCC_MEM_DDR_SUBSETSPS1                           UCDD_MEM_DDR_SUBSETSPS1
#define	AVCC_MEM_DDR_SVBB2                                UCDD_MEM_DDR_SVBB2
#define	AVCC_MEM_DDR_SCEB0                                UCDD_MEM_DDR_SCEB0
#define	AVCC_MEM_DDR_VBB2                                 UCDD_MEM_DDR_VBB2
#define	AVCC_MEM_DDR_VDB2                                 UCDD_MEM_DDR_VDB2
#define	AVCC_MEM_DDR_PARAM2                               UCDD_MEM_DDR_PARAM2
#define	AVCC_MEM_DDR_NONVCLPRM2                           UCDD_MEM_DDR_NONVCLPRM2
#define	AVCC_MEM_DDR_SLHPRM2                              UCDD_MEM_DDR_SLHPRM2
#define	AVCC_MEM_DDR_SEIMSG2                              UCDD_MEM_DDR_SEIMSG2
#define	AVCC_MEM_DDR_DPBINFOPRM2                          UCDD_MEM_DDR_DPBINFOPRM2
#define	AVCC_MEM_DDR_RPLPRM2                              UCDD_MEM_DDR_RPLPRM2
#define	AVCC_MEM_DDR_QMTRXPRM2                            UCDD_MEM_DDR_QMTRXPRM2
#define	AVCC_MEM_DDR_DECINFOPRM2                          UCDD_MEM_DDR_DECINFOPRM2
#define	AVCC_MEM_DDR_ACODECPRM2                           UCDD_MEM_DDR_ACODECPRM2
#define	AVCC_MEM_DDR_MKVPRM2                              UCDD_MEM_DDR_MKVPRM2
#define	AVCC_MEM_DDR_MP4PRM2                              UCDD_MEM_DDR_MP4PRM2
#define	AVCC_MEM_DDR_SWWORKBUFF2                          UCDD_MEM_DDR_SWWORKBUFF2
#define	AVCC_MEM_DDR_SUBSETSPS2                           UCDD_MEM_DDR_SUBSETSPS2
#define	AVCC_MEM_DDR_SW_DECODER                           UCDD_MEM_DDR_SW_DECODER
#define	AVCC_MEM_DDR_COLPIC0                              UCDD_MEM_DDR_COLPIC0
#define	AVCC_MEM_DDR_COLPIC1                              UCDD_MEM_DDR_COLPIC1
#define	AVCC_MEM_DDR_COLPIC2                              UCDD_MEM_DDR_COLPIC2
#define	AVCC_MEM_DDR_VEB0                                 UCDD_MEM_DDR_VEB0
#define	AVCC_MEM_DDR_VEBPRE0                              UCDD_MEM_DDR_VEBPRE0
#define	AVCC_MEM_DDR_ENCCOLPIC0                           UCDD_MEM_DDR_ENCCOLPIC0
#define	AVCC_MEM_DDR_ENCPARAM0                            UCDD_MEM_DDR_ENCPARAM0
#define	AVCC_MEM_DDR_ENCDPB0                              UCDD_MEM_DDR_ENCDPB0
#define	AVCC_MEM_DDR_ENCDPB0_Y0                           UCDD_MEM_DDR_ENCDPB0_Y0
#define	AVCC_MEM_DDR_ENCDPB0_Y1                           UCDD_MEM_DDR_ENCDPB0_Y1
#define	AVCC_MEM_DDR_ENCDPB0_Y2                           UCDD_MEM_DDR_ENCDPB0_Y2
#define	AVCC_MEM_DDR_ENCDPB0_C0                           UCDD_MEM_DDR_ENCDPB0_C0
#define	AVCC_MEM_DDR_ENCDPB0_C1                           UCDD_MEM_DDR_ENCDPB0_C1
#define	AVCC_MEM_DDR_ENCDPB0_C2                           UCDD_MEM_DDR_ENCDPB0_C2
#define	AVCC_MEM_DDR_VEB1                                 UCDD_MEM_DDR_VEB1
#define	AVCC_MEM_DDR_VEBPRE1                              UCDD_MEM_DDR_VEBPRE1
#define	AVCC_MEM_DDR_ENCCOLPIC1                           UCDD_MEM_DDR_ENCCOLPIC1
#define	AVCC_MEM_DDR_ENCPARAM1                            UCDD_MEM_DDR_ENCPARAM1
#define	AVCC_MEM_DDR_ENCDPB1                              UCDD_MEM_DDR_ENCDPB1
#define	AVCC_MEM_DDR_ENCDPB1_Y0                           UCDD_MEM_DDR_ENCDPB1_Y0
#define	AVCC_MEM_DDR_ENCDPB1_Y1                           UCDD_MEM_DDR_ENCDPB1_Y1
#define	AVCC_MEM_DDR_ENCDPB1_Y2                           UCDD_MEM_DDR_ENCDPB1_Y2
#define	AVCC_MEM_DDR_ENCDPB1_C0                           UCDD_MEM_DDR_ENCDPB1_C0
#define	AVCC_MEM_DDR_ENCDPB1_C1                           UCDD_MEM_DDR_ENCDPB1_C1
#define	AVCC_MEM_DDR_ENCDPB1_C2                           UCDD_MEM_DDR_ENCDPB1_C2
#define	AVCC_MEM_DDR_DDR_CH1                              UCDD_MEM_DDR_DDR_CH1
#define	AVCC_MEM_DDR_FRAMEBUF0                            UCDD_MEM_DDR_FRAMEBUF0
#define	AVCC_MEM_DDR_FRAMEBUF0_Y0                         UCDD_MEM_DDR_FRAMEBUF0_Y0
#define	AVCC_MEM_DDR_FRAMEBUF0_Y1                         UCDD_MEM_DDR_FRAMEBUF0_Y1
#define	AVCC_MEM_DDR_FRAMEBUF0_Y2                         UCDD_MEM_DDR_FRAMEBUF0_Y2
#define	AVCC_MEM_DDR_FRAMEBUF0_Y3                         UCDD_MEM_DDR_FRAMEBUF0_Y3
#define	AVCC_MEM_DDR_FRAMEBUF0_Y4                         UCDD_MEM_DDR_FRAMEBUF0_Y4
#define	AVCC_MEM_DDR_FRAMEBUF0_Y5                         UCDD_MEM_DDR_FRAMEBUF0_Y5
#define	AVCC_MEM_DDR_FRAMEBUF0_Y6                         UCDD_MEM_DDR_FRAMEBUF0_Y6
#define	AVCC_MEM_DDR_FRAMEBUF0_Y7                         UCDD_MEM_DDR_FRAMEBUF0_Y7
#define	AVCC_MEM_DDR_FRAMEBUF0_Y8                         UCDD_MEM_DDR_FRAMEBUF0_Y8
#define	AVCC_MEM_DDR_FRAMEBUF0_Y9                         UCDD_MEM_DDR_FRAMEBUF0_Y9
#define	AVCC_MEM_DDR_FRAMEBUF0_Y10                        UCDD_MEM_DDR_FRAMEBUF0_Y10
#define	AVCC_MEM_DDR_FRAMEBUF0_Y11                        UCDD_MEM_DDR_FRAMEBUF0_Y11
#define	AVCC_MEM_DDR_FRAMEBUF0_Y12                        UCDD_MEM_DDR_FRAMEBUF0_Y12
#define	AVCC_MEM_DDR_FRAMEBUF0_Y13                        UCDD_MEM_DDR_FRAMEBUF0_Y13
#define	AVCC_MEM_DDR_FRAMEBUF0_Y14                        UCDD_MEM_DDR_FRAMEBUF0_Y14
#define	AVCC_MEM_DDR_FRAMEBUF0_Y15                        UCDD_MEM_DDR_FRAMEBUF0_Y15
#define	AVCC_MEM_DDR_FRAMEBUF0_Y16                        UCDD_MEM_DDR_FRAMEBUF0_Y16
#define	AVCC_MEM_DDR_FRAMEBUF0_Y17                        UCDD_MEM_DDR_FRAMEBUF0_Y17
#define	AVCC_MEM_DDR_FRAMEBUF0_Y18                        UCDD_MEM_DDR_FRAMEBUF0_Y18
#define	AVCC_MEM_DDR_FRAMEBUF0_Y19                        UCDD_MEM_DDR_FRAMEBUF0_Y19
#define	AVCC_MEM_DDR_FRAMEBUF0_C0                         UCDD_MEM_DDR_FRAMEBUF0_C0
#define	AVCC_MEM_DDR_FRAMEBUF0_C1                         UCDD_MEM_DDR_FRAMEBUF0_C1
#define	AVCC_MEM_DDR_FRAMEBUF0_C2                         UCDD_MEM_DDR_FRAMEBUF0_C2
#define	AVCC_MEM_DDR_FRAMEBUF0_C3                         UCDD_MEM_DDR_FRAMEBUF0_C3
#define	AVCC_MEM_DDR_FRAMEBUF0_C4                         UCDD_MEM_DDR_FRAMEBUF0_C4
#define	AVCC_MEM_DDR_FRAMEBUF0_C5                         UCDD_MEM_DDR_FRAMEBUF0_C5
#define	AVCC_MEM_DDR_FRAMEBUF0_C6                         UCDD_MEM_DDR_FRAMEBUF0_C6
#define	AVCC_MEM_DDR_FRAMEBUF0_C7                         UCDD_MEM_DDR_FRAMEBUF0_C7
#define	AVCC_MEM_DDR_FRAMEBUF0_C8                         UCDD_MEM_DDR_FRAMEBUF0_C8
#define	AVCC_MEM_DDR_FRAMEBUF0_C9                         UCDD_MEM_DDR_FRAMEBUF0_C9
#define	AVCC_MEM_DDR_FRAMEBUF0_C10                        UCDD_MEM_DDR_FRAMEBUF0_C10
#define	AVCC_MEM_DDR_FRAMEBUF0_C11                        UCDD_MEM_DDR_FRAMEBUF0_C11
#define	AVCC_MEM_DDR_FRAMEBUF0_C12                        UCDD_MEM_DDR_FRAMEBUF0_C12
#define	AVCC_MEM_DDR_FRAMEBUF0_C13                        UCDD_MEM_DDR_FRAMEBUF0_C13
#define	AVCC_MEM_DDR_FRAMEBUF0_C14                        UCDD_MEM_DDR_FRAMEBUF0_C14
#define	AVCC_MEM_DDR_FRAMEBUF0_C15                        UCDD_MEM_DDR_FRAMEBUF0_C15
#define	AVCC_MEM_DDR_FRAMEBUF0_C16                        UCDD_MEM_DDR_FRAMEBUF0_C16
#define	AVCC_MEM_DDR_FRAMEBUF0_C17                        UCDD_MEM_DDR_FRAMEBUF0_C17
#define	AVCC_MEM_DDR_FRAMEBUF0_C18                        UCDD_MEM_DDR_FRAMEBUF0_C18
#define	AVCC_MEM_DDR_FRAMEBUF0_C19                        UCDD_MEM_DDR_FRAMEBUF0_C19
#define	AVCC_MEM_DDR_FM_STILL0_Y                          UCDD_MEM_DDR_FM_STILL0_Y
#define	AVCC_MEM_DDR_FM_STILL0_C                          UCDD_MEM_DDR_FM_STILL0_C
#define	AVCC_MEM_DDR_BDJ_WORK                             UCDD_MEM_DDR_BDJ_WORK
#define	AVCC_MEM_DDR_DV0                                  UCDD_MEM_DDR_DV0
#define	AVCC_MEM_DDR_FRAMEBUF1                            UCDD_MEM_DDR_FRAMEBUF1
#define	AVCC_MEM_DDR_FRAMEBUF1_Y0                         UCDD_MEM_DDR_FRAMEBUF1_Y0
#define	AVCC_MEM_DDR_FRAMEBUF1_Y1                         UCDD_MEM_DDR_FRAMEBUF1_Y1
#define	AVCC_MEM_DDR_FRAMEBUF1_Y2                         UCDD_MEM_DDR_FRAMEBUF1_Y2
#define	AVCC_MEM_DDR_FRAMEBUF1_Y3                         UCDD_MEM_DDR_FRAMEBUF1_Y3
#define	AVCC_MEM_DDR_FRAMEBUF1_Y4                         UCDD_MEM_DDR_FRAMEBUF1_Y4
#define	AVCC_MEM_DDR_FRAMEBUF1_Y5                         UCDD_MEM_DDR_FRAMEBUF1_Y5
#define	AVCC_MEM_DDR_FRAMEBUF1_Y6                         UCDD_MEM_DDR_FRAMEBUF1_Y6
#define	AVCC_MEM_DDR_FRAMEBUF1_Y7                         UCDD_MEM_DDR_FRAMEBUF1_Y7
#define	AVCC_MEM_DDR_FRAMEBUF1_Y8                         UCDD_MEM_DDR_FRAMEBUF1_Y8
#define	AVCC_MEM_DDR_FRAMEBUF1_Y9                         UCDD_MEM_DDR_FRAMEBUF1_Y9
#define	AVCC_MEM_DDR_FRAMEBUF1_Y10                        UCDD_MEM_DDR_FRAMEBUF1_Y10
#define	AVCC_MEM_DDR_FRAMEBUF1_Y11                        UCDD_MEM_DDR_FRAMEBUF1_Y11
#define	AVCC_MEM_DDR_FRAMEBUF1_Y12                        UCDD_MEM_DDR_FRAMEBUF1_Y12
#define	AVCC_MEM_DDR_FRAMEBUF1_Y13                        UCDD_MEM_DDR_FRAMEBUF1_Y13
#define	AVCC_MEM_DDR_FRAMEBUF1_Y14                        UCDD_MEM_DDR_FRAMEBUF1_Y14
#define	AVCC_MEM_DDR_FRAMEBUF1_Y15                        UCDD_MEM_DDR_FRAMEBUF1_Y15
#define	AVCC_MEM_DDR_FRAMEBUF1_Y16                        UCDD_MEM_DDR_FRAMEBUF1_Y16
#define	AVCC_MEM_DDR_FRAMEBUF1_Y17                        UCDD_MEM_DDR_FRAMEBUF1_Y17
#define	AVCC_MEM_DDR_FRAMEBUF1_Y18                        UCDD_MEM_DDR_FRAMEBUF1_Y18
#define	AVCC_MEM_DDR_FRAMEBUF1_Y19                        UCDD_MEM_DDR_FRAMEBUF1_Y19
#define	AVCC_MEM_DDR_FRAMEBUF1_C0                         UCDD_MEM_DDR_FRAMEBUF1_C0
#define	AVCC_MEM_DDR_FRAMEBUF1_C1                         UCDD_MEM_DDR_FRAMEBUF1_C1
#define	AVCC_MEM_DDR_FRAMEBUF1_C2                         UCDD_MEM_DDR_FRAMEBUF1_C2
#define	AVCC_MEM_DDR_FRAMEBUF1_C3                         UCDD_MEM_DDR_FRAMEBUF1_C3
#define	AVCC_MEM_DDR_FRAMEBUF1_C4                         UCDD_MEM_DDR_FRAMEBUF1_C4
#define	AVCC_MEM_DDR_FRAMEBUF1_C5                         UCDD_MEM_DDR_FRAMEBUF1_C5
#define	AVCC_MEM_DDR_FRAMEBUF1_C6                         UCDD_MEM_DDR_FRAMEBUF1_C6
#define	AVCC_MEM_DDR_FRAMEBUF1_C7                         UCDD_MEM_DDR_FRAMEBUF1_C7
#define	AVCC_MEM_DDR_FRAMEBUF1_C8                         UCDD_MEM_DDR_FRAMEBUF1_C8
#define	AVCC_MEM_DDR_FRAMEBUF1_C9                         UCDD_MEM_DDR_FRAMEBUF1_C9
#define	AVCC_MEM_DDR_FRAMEBUF1_C10                        UCDD_MEM_DDR_FRAMEBUF1_C10
#define	AVCC_MEM_DDR_FRAMEBUF1_C11                        UCDD_MEM_DDR_FRAMEBUF1_C11
#define	AVCC_MEM_DDR_FRAMEBUF1_C12                        UCDD_MEM_DDR_FRAMEBUF1_C12
#define	AVCC_MEM_DDR_FRAMEBUF1_C13                        UCDD_MEM_DDR_FRAMEBUF1_C13
#define	AVCC_MEM_DDR_FRAMEBUF1_C14                        UCDD_MEM_DDR_FRAMEBUF1_C14
#define	AVCC_MEM_DDR_FRAMEBUF1_C15                        UCDD_MEM_DDR_FRAMEBUF1_C15
#define	AVCC_MEM_DDR_FRAMEBUF1_C16                        UCDD_MEM_DDR_FRAMEBUF1_C16
#define	AVCC_MEM_DDR_FRAMEBUF1_C17                        UCDD_MEM_DDR_FRAMEBUF1_C17
#define	AVCC_MEM_DDR_FRAMEBUF1_C18                        UCDD_MEM_DDR_FRAMEBUF1_C18
#define	AVCC_MEM_DDR_FRAMEBUF1_C19                        UCDD_MEM_DDR_FRAMEBUF1_C19
#define	AVCC_MEM_DDR_AIOF                                 UCDD_MEM_DDR_AIOF
#define	AVCC_MEM_DDR_DV1                                  UCDD_MEM_DDR_DV1
#define	AVCC_MEM_DDR_SNIP_Y                               UCDD_MEM_DDR_SNIP_Y
#define	AVCC_MEM_DDR_SNIP_C                               UCDD_MEM_DDR_SNIP_C
#define	AVCC_MEM_DDR_ME0                                  UCDD_MEM_DDR_ME0
#define	AVCC_MEM_DDR_ENCBUF0                              UCDD_MEM_DDR_ENCBUF0
#define	AVCC_MEM_DDR_ENCBUF0_Y0                           UCDD_MEM_DDR_ENCBUF0_Y0
#define	AVCC_MEM_DDR_ENCBUF0_Y1                           UCDD_MEM_DDR_ENCBUF0_Y1
#define	AVCC_MEM_DDR_ENCBUF0_Y2                           UCDD_MEM_DDR_ENCBUF0_Y2
#define	AVCC_MEM_DDR_ENCBUF0_Y3                           UCDD_MEM_DDR_ENCBUF0_Y3
#define	AVCC_MEM_DDR_ENCBUF0_Y4                           UCDD_MEM_DDR_ENCBUF0_Y4
#define	AVCC_MEM_DDR_ENCBUF0_Y5                           UCDD_MEM_DDR_ENCBUF0_Y5
#define	AVCC_MEM_DDR_ENCBUF0_Y6                           UCDD_MEM_DDR_ENCBUF0_Y6
#define	AVCC_MEM_DDR_ENCBUF0_C0                           UCDD_MEM_DDR_ENCBUF0_C0
#define	AVCC_MEM_DDR_ENCBUF0_C1                           UCDD_MEM_DDR_ENCBUF0_C1
#define	AVCC_MEM_DDR_ENCBUF0_C2                           UCDD_MEM_DDR_ENCBUF0_C2
#define	AVCC_MEM_DDR_ENCBUF0_C3                           UCDD_MEM_DDR_ENCBUF0_C3
#define	AVCC_MEM_DDR_ENCBUF0_C4                           UCDD_MEM_DDR_ENCBUF0_C4
#define	AVCC_MEM_DDR_ENCBUF0_C5                           UCDD_MEM_DDR_ENCBUF0_C5
#define	AVCC_MEM_DDR_ENCBUF0_C6                           UCDD_MEM_DDR_ENCBUF0_C6
#define	AVCC_MEM_DDR_ME1                                  UCDD_MEM_DDR_ME1
#define	AVCC_MEM_DDR_ENCBUF1                              UCDD_MEM_DDR_ENCBUF1
#define	AVCC_MEM_DDR_ENCBUF1_Y0                           UCDD_MEM_DDR_ENCBUF1_Y0
#define	AVCC_MEM_DDR_ENCBUF1_Y1                           UCDD_MEM_DDR_ENCBUF1_Y1
#define	AVCC_MEM_DDR_ENCBUF1_Y2                           UCDD_MEM_DDR_ENCBUF1_Y2
#define	AVCC_MEM_DDR_ENCBUF1_Y3                           UCDD_MEM_DDR_ENCBUF1_Y3
#define	AVCC_MEM_DDR_ENCBUF1_Y4                           UCDD_MEM_DDR_ENCBUF1_Y4
#define	AVCC_MEM_DDR_ENCBUF1_Y5                           UCDD_MEM_DDR_ENCBUF1_Y5
#define	AVCC_MEM_DDR_ENCBUF1_Y6                           UCDD_MEM_DDR_ENCBUF1_Y6
#define	AVCC_MEM_DDR_ENCBUF1_C0                           UCDD_MEM_DDR_ENCBUF1_C0
#define	AVCC_MEM_DDR_ENCBUF1_C1                           UCDD_MEM_DDR_ENCBUF1_C1
#define	AVCC_MEM_DDR_ENCBUF1_C2                           UCDD_MEM_DDR_ENCBUF1_C2
#define	AVCC_MEM_DDR_ENCBUF1_C3                           UCDD_MEM_DDR_ENCBUF1_C3
#define	AVCC_MEM_DDR_ENCBUF1_C4                           UCDD_MEM_DDR_ENCBUF1_C4
#define	AVCC_MEM_DDR_ENCBUF1_C5                           UCDD_MEM_DDR_ENCBUF1_C5
#define	AVCC_MEM_DDR_ENCBUF1_C6                           UCDD_MEM_DDR_ENCBUF1_C6
#define	AVCC_MEM_DDR_JPEG_SW_DEC_WORK_0                   UCDD_MEM_DDR_JPEG_SW_DEC_WORK_0
#define	AVCC_MEM_DDR_JPEG_DEC_OUTBUF_Y0                   UCDD_MEM_DDR_JPEG_DEC_OUTBUF_Y0
#define	AVCC_MEM_DDR_JPEG_DEC_OUTBUF_C0                   UCDD_MEM_DDR_JPEG_DEC_OUTBUF_C0
#define	AVCC_MEM_DDR_JPEG_DEC_OUTBUF_Y1                   UCDD_MEM_DDR_JPEG_DEC_OUTBUF_Y1
#define	AVCC_MEM_DDR_JPEG_DEC_OUTBUF_C1                   UCDD_MEM_DDR_JPEG_DEC_OUTBUF_C1
#define	AVCC_MEM_DDR_JPEG_TRANS_BUF_Y0                    UCDD_MEM_DDR_JPEG_TRANS_BUF_Y0
#define	AVCC_MEM_DDR_JPEG_TRANS_BUF_C0                    UCDD_MEM_DDR_JPEG_TRANS_BUF_C0
#define	AVCC_MEM_DDR_JPEG_LANCZOS_BUF                     UCDD_MEM_DDR_JPEG_LANCZOS_BUF
#define	AVCC_MEM_DDR_JPEG_HW_DEC_RESULT_Y                 UCDD_MEM_DDR_JPEG_HW_DEC_RESULT_Y
#define	AVCC_MEM_DDR_JPEG_HW_DEC_RESULT_C                 UCDD_MEM_DDR_JPEG_HW_DEC_RESULT_C
#define	AVCC_MEM_DDR_JPEG_HW_DEC_RESULT0                  UCDD_MEM_DDR_JPEG_HW_DEC_RESULT0
#define	AVCC_MEM_DDR_JPEG_HW_DEC_RESULT1                  UCDD_MEM_DDR_JPEG_HW_DEC_RESULT1
#define	AVCC_MEM_NOT_USED                                 UCDD_MEM_NOT_USED
#define	AVCC_MEM_N                                        UCDD_MEM_N

#if defined(_UCD_MEM_MAP_C_)

#if defined(REVISION_PH1SLD3_ES2) || !defined(CONFIG_MN2WS0220_ES1) || defined(MN2WS0220_ES) && (MN2WS0220_ES == 2)
#include	"ucd_mem_map_model.h"
#define MEM_MAP(sym, rule, mmap_p, fm_y_p, fm_c_p)                    \
	[UCDD_MEM_ ## sym] = {0, {rule, mmap_p, fm_y_p, fm_c_p},              \
	{ucd_mem_map_model_ ## sym}}

#else
#endif

static struct mem_map ucd_mem_map[] = {
	MEM_MAP(RLE1                                    , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(RLE2                                    , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(RLEIOP0                                 , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(RLEIOP1                                 , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(RLEDMAC                                 , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(FDMAC                                   , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(SYS                                     , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(HCM                                     , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(HSC                                     , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(AIOF                                    , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(IPR                                     , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(VOUT                                    , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(HOSTIOP                                 , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(HASI                                    , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(LOSD                                    , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(AVCORE                                  , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(SOCGLUE                                 , UCD_MEM_TYPE_SOC              , 1, 0, 0),
	MEM_MAP(DDR_DDR_CH0                             , UCD_MEM_TYPE_DDR0             , 0, 0, 0),
	MEM_MAP(DDR_INST_PARAM                          , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_DPPINSTST_0_H264                    , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_HCMDDR_OFFSET                       , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_JPEG_TABLE0                         , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_JPEG_HUFFMAN_TABLE0                 , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_JPEG_Q_TABLE0                       , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_JPEG_TABLE1                         , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_JPEG_HUFFMAN_TABLE1                 , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_JPEG_Q_TABLE1                       , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_UDLWORK                             , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_SABB0                               , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_SABB1                               , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_SABB2                               , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_SAE2B0                              , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_ADB                                 , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_ABB0                                , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_ABB1                                , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_ABB2                                , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AOB                                 , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AOB0                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AOB1                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AOB2                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AIB                                 , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AIB0                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AIB1                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_REMASTER0                           , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_REMASTER1                           , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_HBASSPARAM0                         , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_HBASSPARAM1                         , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_PCMMIX0                             , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_PCMMIX1                             , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_PCMMIX2                             , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_BRFILTERCOEF0                       , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_BRFILTERCOEF1                       , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_BRFILTERCOEF2                       , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AUDMIXM2A                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2B                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2C                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2D                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2E                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2F                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2G                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AUDMIXM2H                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_AEB0                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AEB1                                , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_TRANS_AEB0                          , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_TRANS_AEB1                          , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_SIT_AND_PMT0                        , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_SIT_AND_PMT1                        , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_APTS_TABLE_DEC                      , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_APTS_TABLE_DEC0                     , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_APTS_TABLE_DEC1                     , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_APTS_TABLE_DEC2                     , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_RMAACFRM0                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_RMAACFRM1                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_RMAACFRM2                           , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_ADECINF0                            , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_ADECINF1                            , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_ADECINF2                            , UCD_MEM_TYPE_UCODE            , 1, 0, 0),
	MEM_MAP(DDR_APTS_TABLE0                         , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_APTS_TABLE1                         , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_SDCARD                              , UCD_MEM_TYPE_UCODE            , 0, 0, 0),
	MEM_MAP(DDR_AE1B0                               , UCD_MEM_TYPE_UCODE            , 0, 0, 1),
	MEM_MAP(DDR_AE2B0                               , UCD_MEM_TYPE_UCODE            , 0, 0, 1),
	MEM_MAP(DDR_CEB0                                , UCD_MEM_TYPE_UCODE            , 0, 0, 1),
	MEM_MAP(DDR_AE1PTS_TABLE0                       , UCD_MEM_TYPE_UCODE            , 0, 0, 1),
	MEM_MAP(DDR_AE2PTS_TABLE0                       , UCD_MEM_TYPE_UCODE            , 0, 0, 1),
	MEM_MAP(DDR_CEPTS_TABLE0                        , UCD_MEM_TYPE_UCODE            , 0, 0, 1),
	MEM_MAP(DDR_FCARDADDR                           , UCD_MEM_TYPE_VIDEO            , 1, 0, 0),
	MEM_MAP(DDR_COEF                                , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FCCOEF                              , UCD_MEM_TYPE_VIDEO            , 1, 0, 0),
	MEM_MAP(DDR_TELETEXT                            , UCD_MEM_TYPE_VIDEO            , 1, 0, 0),
	MEM_MAP(DDR_MNIP_Y                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MNIP_C                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_Y0                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_Y1                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_Y2                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_Y3                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_C0                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_C1                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_C2                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_MVR_C3                              , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_SVR0                                , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_SVR1                                , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_SVR2                                , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_SVR3                                , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER2_IPCONV                      , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER1Y                            , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER1C                            , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER2Y                            , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER2C                            , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTEREXIVY                         , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTEREXIVC                         , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER2ND_A                         , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_FILTER2ND_B                         , UCD_MEM_TYPE_VIDEO            , 0, 0, 0),
	MEM_MAP(DDR_IOSD0_0                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSD0_1                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSD0_2                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSD1_0                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSD1_1                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSD1_2                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CURSOR_0                            , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CURSOR_1                            , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CLUT0                               , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CLUT1                               , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CLUT2                               , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CLUT3                               , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CLUT4                               , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_CLUT5                               , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_0                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_0_L                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_0_R                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_1                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_1_L                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_1_R                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_2                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_2_L                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD0_2_R                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_0                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_0_L                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_0_R                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_1                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_1_L                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_1_R                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_2                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_2_L                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD1_2_R                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_VOSD                                , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_DDI_GPU                             , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_LOSD_BUFFER                         , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_EPG_BUFFER                          , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_AJAX_BUFFER0                        , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_AJAX_BUFFER1                        , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDB0                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDB1                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDC0                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDC1                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDD0                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDD1                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_PG                                  , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_PGCBB                               , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGCBB0                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGCBB1                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGCDBB                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGCDBB0                             , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGCDBB1                             , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE                           , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE0                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE0_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE0_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE1                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE1_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOBTABLE1_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOB                                , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOB0                               , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGOB1                               , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE                           , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE0                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE0_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE0_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE1                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE1_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_PGPBTABLE1_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IOSDA0                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IOSDA1                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IG                                  , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_IGCBB                               , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBB0                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBB0_0                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBB0_1                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBB1                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBB1_0                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBB1_1                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCDBB                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCDBB0                             , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCDBB1                             , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE                           , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE0                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE0_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE0_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE1                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE1_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGOBTABLE1_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB                               , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB0                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB0_0                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB0_1                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB1                              , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB1_0                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGDOB1_1                            , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE                           , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE0                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE0_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE0_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE1                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE1_0                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGPBTABLE1_1                        , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBTABLE                           , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBTABLE0                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_IGCBTABLE1                          , UCD_MEM_TYPE_GFX0             , 0, 0, 0),
	MEM_MAP(DDR_STILL0_Y0                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL0_C0                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL0_Y1                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL0_C1                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL1_Y0                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL1_C0                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL1_Y1                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_STILL1_C1                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_BDJIMGAUD                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_THUMBNAIL                           , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_RLE                                 , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_SPUBB0                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_SPUBB1                              , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_SPU0                                , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_SPU1                                , UCD_MEM_TYPE_GFX0             , 1, 0, 0),
	MEM_MAP(DDR_SVBB0                               , UCD_MEM_TYPE_DEC0_0           , 1, 0, 0),
	MEM_MAP(DDR_VBB0                                , UCD_MEM_TYPE_DEC0_0           , 1, 0, 0),
	MEM_MAP(DDR_VDB0                                , UCD_MEM_TYPE_DEC0_0           , 1, 0, 0),
	MEM_MAP(DDR_PARAM0                              , UCD_MEM_TYPE_DEC0_0           , 1, 0, 0),
	MEM_MAP(DDR_NONVCLPRM0                          , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_SLHPRM0                             , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_SEIMSG0                             , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_DPBINFOPRM0                         , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_RPLPRM0                             , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_QMTRXPRM0                           , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_DECINFOPRM0                         , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_ACODECPRM0                          , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_MKVPRM0                             , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_MP4PRM0                             , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_SWWORKBUFF0                         , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_SUBSETSPS0                          , UCD_MEM_TYPE_DEC0_0           , 0, 0, 0),
	MEM_MAP(DDR_SVBB1                               , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_VBB1                                , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_VDB1                                , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_PARAM1                              , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_NONVCLPRM1                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SLHPRM1                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SEIMSG1                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_DPBINFOPRM1                         , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_RPLPRM1                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_QMTRXPRM1                           , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_DECINFOPRM1                         , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_ACODECPRM1                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_MKVPRM1                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_MP4PRM1                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SWWORKBUFF1                         , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SUBSETSPS1                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SVBB2                               , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_SCEB0                               , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_VBB2                                , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_VDB2                                , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_PARAM2                              , UCD_MEM_TYPE_DEC1_0           , 1, 0, 0),
	MEM_MAP(DDR_NONVCLPRM2                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SLHPRM2                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SEIMSG2                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_DPBINFOPRM2                         , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_RPLPRM2                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_QMTRXPRM2                           , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_DECINFOPRM2                         , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_ACODECPRM2                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_MKVPRM2                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_MP4PRM2                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SWWORKBUFF2                         , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SUBSETSPS2                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_SW_DECODER                          , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_COLPIC0                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_COLPIC1                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_COLPIC2                             , UCD_MEM_TYPE_DEC1_0           , 0, 0, 0),
	MEM_MAP(DDR_VEB0                                , UCD_MEM_TYPE_ENC0_0           , 0, 0, 0),
	MEM_MAP(DDR_VEBPRE0                             , UCD_MEM_TYPE_ENC0_0           , 0, 0, 0),
	MEM_MAP(DDR_ENCCOLPIC0                          , UCD_MEM_TYPE_ENC0_0           , 0, 0, 0),
	MEM_MAP(DDR_ENCPARAM0                           , UCD_MEM_TYPE_ENC0_0           , 1, 0, 0),
	MEM_MAP(DDR_ENCDPB0                             , UCD_MEM_TYPE_ENC0_0           , 0, 1, 1),
	MEM_MAP(DDR_ENCDPB0_Y0                          , UCD_MEM_TYPE_ENC0_0           , 0, 1, 0),
	MEM_MAP(DDR_ENCDPB0_Y1                          , UCD_MEM_TYPE_ENC0_0           , 0, 1, 0),
	MEM_MAP(DDR_ENCDPB0_Y2                          , UCD_MEM_TYPE_ENC0_0           , 0, 1, 0),
	MEM_MAP(DDR_ENCDPB0_C0                          , UCD_MEM_TYPE_ENC0_0           , 0, 0, 1),
	MEM_MAP(DDR_ENCDPB0_C1                          , UCD_MEM_TYPE_ENC0_0           , 0, 0, 1),
	MEM_MAP(DDR_ENCDPB0_C2                          , UCD_MEM_TYPE_ENC0_0           , 0, 0, 1),
	MEM_MAP(DDR_VEB1                                , UCD_MEM_TYPE_ENC1_0           , 0, 0, 0),
	MEM_MAP(DDR_VEBPRE1                             , UCD_MEM_TYPE_ENC1_0           , 0, 0, 0),
	MEM_MAP(DDR_ENCCOLPIC1                          , UCD_MEM_TYPE_ENC1_0           , 0, 0, 0),
	MEM_MAP(DDR_ENCPARAM1                           , UCD_MEM_TYPE_ENC1_0           , 1, 0, 0),
	MEM_MAP(DDR_ENCDPB1                             , UCD_MEM_TYPE_ENC1_0           , 0, 1, 1),
	MEM_MAP(DDR_ENCDPB1_Y0                          , UCD_MEM_TYPE_ENC1_0           , 0, 1, 0),
	MEM_MAP(DDR_ENCDPB1_Y1                          , UCD_MEM_TYPE_ENC1_0           , 0, 1, 0),
	MEM_MAP(DDR_ENCDPB1_Y2                          , UCD_MEM_TYPE_ENC1_0           , 0, 1, 0),
	MEM_MAP(DDR_ENCDPB1_C0                          , UCD_MEM_TYPE_ENC1_0           , 0, 0, 1),
	MEM_MAP(DDR_ENCDPB1_C1                          , UCD_MEM_TYPE_ENC1_0           , 0, 0, 1),
	MEM_MAP(DDR_ENCDPB1_C2                          , UCD_MEM_TYPE_ENC1_0           , 0, 0, 1),
	MEM_MAP(DDR_DDR_CH1                             , UCD_MEM_TYPE_DDR1             , 0, 0, 0),
	MEM_MAP(DDR_FRAMEBUF0                           , UCD_MEM_TYPE_DEC0_1           , 1, 1, 1),
	MEM_MAP(DDR_FRAMEBUF0_Y0                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y1                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y2                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y3                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y4                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y5                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y6                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y7                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y8                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y9                        , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y10                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y11                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y12                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y13                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y14                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y15                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y16                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y17                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y18                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_Y19                       , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF0_C0                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C1                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C2                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C3                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C4                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C5                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C6                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C7                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C8                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C9                        , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C10                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C11                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C12                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C13                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C14                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C15                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C16                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C17                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C18                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF0_C19                       , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_FM_STILL0_Y                         , UCD_MEM_TYPE_DEC0_1           , 1, 1, 0),
	MEM_MAP(DDR_FM_STILL0_C                         , UCD_MEM_TYPE_DEC0_1           , 1, 0, 1),
	MEM_MAP(DDR_BDJ_WORK                            , UCD_MEM_TYPE_DEC0_1           , 1, 0, 0),
	MEM_MAP(DDR_DV0                                 , UCD_MEM_TYPE_DEC0_1           , 0, 0, 0),
	MEM_MAP(DDR_FRAMEBUF1                           , UCD_MEM_TYPE_DEC1_1           , 1, 1, 1),
	MEM_MAP(DDR_FRAMEBUF1_Y0                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y1                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y2                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y3                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y4                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y5                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y6                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y7                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y8                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y9                        , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y10                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y11                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y12                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y13                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y14                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y15                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y16                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y17                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y18                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_Y19                       , UCD_MEM_TYPE_DEC1_1           , 1, 1, 0),
	MEM_MAP(DDR_FRAMEBUF1_C0                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C1                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C2                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C3                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C4                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C5                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C6                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C7                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C8                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C9                        , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C10                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C11                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C12                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C13                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C14                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C15                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C16                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C17                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C18                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_FRAMEBUF1_C19                       , UCD_MEM_TYPE_DEC1_1           , 1, 0, 1),
	MEM_MAP(DDR_AIOF                                , UCD_MEM_TYPE_DEC1_1           , 0, 0, 0),
	MEM_MAP(DDR_DV1                                 , UCD_MEM_TYPE_DEC1_1           , 0, 0, 0),
	MEM_MAP(DDR_SNIP_Y                              , UCD_MEM_TYPE_DEC1_1           , 0, 0, 0),
	MEM_MAP(DDR_SNIP_C                              , UCD_MEM_TYPE_DEC1_1           , 0, 0, 0),
	MEM_MAP(DDR_ME0                                 , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0                             , UCD_MEM_TYPE_ENC0_1           , 0, 1, 1),
	MEM_MAP(DDR_ENCBUF0_Y0                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_Y1                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_Y2                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_Y3                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_Y4                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_Y5                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_Y6                          , UCD_MEM_TYPE_ENC0_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF0_C0                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF0_C1                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF0_C2                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF0_C3                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF0_C4                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF0_C5                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF0_C6                          , UCD_MEM_TYPE_ENC0_1           , 0, 0, 1),
	MEM_MAP(DDR_ME1                                 , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1                             , UCD_MEM_TYPE_ENC1_1           , 0, 1, 1),
	MEM_MAP(DDR_ENCBUF1_Y0                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_Y1                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_Y2                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_Y3                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_Y4                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_Y5                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_Y6                          , UCD_MEM_TYPE_ENC1_1           , 0, 1, 0),
	MEM_MAP(DDR_ENCBUF1_C0                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF1_C1                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF1_C2                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF1_C3                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF1_C4                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF1_C5                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_ENCBUF1_C6                          , UCD_MEM_TYPE_ENC1_1           , 0, 0, 1),
	MEM_MAP(DDR_JPEG_SW_DEC_WORK_0                  , UCD_MEM_TYPE_JPEG             , 1, 0, 0),
	MEM_MAP(DDR_JPEG_DEC_OUTBUF_Y0                  , UCD_MEM_TYPE_JPEG             , 1, 1, 0),
	MEM_MAP(DDR_JPEG_DEC_OUTBUF_C0                  , UCD_MEM_TYPE_JPEG             , 1, 0, 1),
	MEM_MAP(DDR_JPEG_DEC_OUTBUF_Y1                  , UCD_MEM_TYPE_JPEG             , 1, 1, 0),
	MEM_MAP(DDR_JPEG_DEC_OUTBUF_C1                  , UCD_MEM_TYPE_JPEG             , 1, 0, 1),
	MEM_MAP(DDR_JPEG_TRANS_BUF_Y0                   , UCD_MEM_TYPE_JPEG             , 1, 1, 0),
	MEM_MAP(DDR_JPEG_TRANS_BUF_C0                   , UCD_MEM_TYPE_JPEG             , 1, 0, 1),
	MEM_MAP(DDR_JPEG_LANCZOS_BUF                    , UCD_MEM_TYPE_JPEG             , 1, 0, 0),
	MEM_MAP(DDR_JPEG_HW_DEC_RESULT_Y                , UCD_MEM_TYPE_JPEG             , 1, 1, 0),
	MEM_MAP(DDR_JPEG_HW_DEC_RESULT_C                , UCD_MEM_TYPE_JPEG             , 1, 0, 1),
	MEM_MAP(DDR_JPEG_HW_DEC_RESULT0                 , UCD_MEM_TYPE_JPEG             , 1, 0, 0),
	MEM_MAP(DDR_JPEG_HW_DEC_RESULT1                 , UCD_MEM_TYPE_JPEG             , 1, 0, 0),
	MEM_MAP(NOT_USED                                , UCD_MEM_TYPE_NOTUSED          , 1, 0, 0),
};
#endif


#endif

